<?php
require_once _PS_ROOT_DIR_ . '/modules/foxpost/classes/FPPackage.php';
require_once _PS_ROOT_DIR_ . '/modules/foxpost/foxpost.php';
/**
 * FoxPost
 *
 * @author Foxpost <kovago.balazs@foxpost.hu>
 * @copyright 2022 FoxPost Zrt.
 * @license   See joined file licence.txt
 * @category  Module
 * @support   Support <b2chelpdesk@foxpost.hu>
 * @version   0.0.1
 * @link      https://www.foxpost.hu
 */


class FPHelper
{

    private $logs = [];

    /**
     * Configure FoxPostApi to this enviromment 
     * 
     * @param $loglevel API log level
     * @return object API object
     */
    private static function getAPI(int $loglevel = 2)
    {
        $loglevel = Configuration::get('FOXPOST_API_LOG_LEVEL');

        $FoxPostApi = new FoxPostApi($loglevel);
        $logdir = _PS_ROOT_DIR_ . DIRECTORY_SEPARATOR . 'modules/foxpost/logs' . DIRECTORY_SEPARATOR . 'API' . DIRECTORY_SEPARATOR;
        $FoxPostApi->setTmpDir($logdir);
        $FoxPostApi->setCred(Configuration::get('FOXPOST_USER'), Configuration::get('FOXPOST_PASS'), Configuration::get('FOXPOST_API'));
        $FoxPostApi->setUserAgent(array('PrestaShop' => _PS_VERSION_));

        $options = include(_PS_MODULE_DIR_ . "foxpost/config.php");
        $FoxPostApi->setConfig($options);

        return $FoxPostApi;
    }


    //PrestaShop
    public static function setLabelToPrestaShop($order, $tracking_number)
    {

        $orderCarrier = new OrderCarrier((int) $order->getIdOrderCarrier());
        $orderCarrier->tracking_number = pSQL($tracking_number);

        $order->shipping_number = pSQL($tracking_number);


        if (!$orderCarrier->update() || !$order->update()) {
            //????$this->errors[] = 'The order carrier cannot be updated.';
            return false;
        } else {
            $customer = new Customer((int) $order->id_customer);
            $carrier = new Carrier((int) $order->id_carrier, (int) $order->getAssociatedLanguage()->getId());

            Hook::exec('actionAdminOrdersTrackingNumberUpdate', [
                'order' => $order,
                'customer' => $customer,
                'carrier' => $carrier,
            ], null, false, true, false, $order->id_shop);
        }

        return true;
    }

    /**
     * 
     * 
     * REPARCEL
     * 
     */
    public static function exportOrder($orders)
    {

        $FoxPostApi = self::getAPI(6);
        $parcels = array();
        foreach ($orders as $order) {
            $package = FPPackage::getFPPackageByOrderId($order->id); //print_r($package);exit;

            if ($package->exported == 1 && FoxPost::getConfig('REPARCEL', 0) == 0) {
                $message[$order->id] = Translate::getModuleTranslation('foxpost', 'Label only export one time!', 'foxpost');
                continue;
            }

            //Soft check
            $parcel_data = FPHelper::convOrder2ParcelData($order);
            if ($parcel_data == false) {
                $message[$order->id] = 'INSUFFICIENT data';
                $package->error = pSQL('INSUFFICIENT data');
            } else {
                $package->error = '';
                $parcels[] = $parcel_data;
                $package->exported = 1;
            }
            $package->update();
        }
        //print_r($parcels);
        //$filename = 'foxpost-export-'.time().'.csv';   
        $FoxPostApi->createCSV($parcels/*, 'labels'.DIRECTORY_SEPARATOR.$filename*/);

        //print_r($FoxPostApi);exit;
        return true;
    }

    /**
     * 
     * 
     * 
     * 
     */
    public static function printLabel($orders)
    {

        $FoxPostApi = self::getAPI(6);
        $barcodes = array();

        foreach ($orders as $order) {
            $package = FPPackage::getFPPackageByOrderId($order->id); //print_r($order);exit;
            $barcodes[] = $package->barcode;
            FPPackage::setS2($package->barcode);
        }

        $pdf_name = $FoxPostApi->parcelLabel($barcodes, FoxPost::getConfig('LABEL_SIZE', 'A7')); //  var_dump($parcel);   var_dump($FoxPostApi);        

        if ($FoxPostApi->error == true) {
            exit("API error: " . $FoxPostApi->getLog());
        }

        $file = _PS_MODULE_DIR_ . "foxpost/logs/API/labels/{$pdf_name}";
        $filesize = filesize($file);
        if ($filesize > 1) {

            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header("Content-Type: application/pdf");

            header('Content-Length: ' . $filesize);

            header('Content-Description: File Transfer');
            header('Content-Disposition: attachment; filename="' . basename($pdf_name) . '"');
            //header("Content-Disposition: inline; filename={$pdf_name}");

            readfile($file);
            exit;
        }
        exit("API/PDF error: " . $FoxPostApi->getLog());
    }

    /**
     * FoxPost
     * Nincs "részleges" feladás, addig nem küldjük el amíg minden adat nem jó
     * RELABEL && REPARCEL 
     * 
     * @return array|false ref=>barcode OR FALSE is error
     * @return $message Error message.
     */
    public static function getLabelFromFoxPost($orders, &$message, $API_LOG_LEVEL = 2)
    {

        $parcels = array();
        foreach ($orders as $order) {
            $package = FPPackage::getFPPackageByOrderId($order->id); //print_r($package);exit;

            if (
                ($package->status > 0 /*$package->barcode!=''*/ && FoxPost::getConfig('REPARCEL', 0) == 0)
                ||
                ($package->printed == 1 && FoxPost::getConfig('RELABEL', 0) == 0)
            ) {
                $message[$order->id] = Translate::getModuleTranslation('foxpost', 'Only once send parcel to Foxpost!', 'foxpost');
                continue;
            }


            //Soft check
            $parcel_data = FPHelper::convOrder2ParcelData($order);
            if ($parcel_data == false) {
                $message[$order->id] = 'INSUFFICIENT data';
                $package->error = pSQL('INSUFFICIENT data');
                $package->update();
            } else {
                $parcels[] = $parcel_data;
            }
        }
        //print_r($parcels);exit;
        if (empty($parcels)) return false;

        $FoxPostApi = self::getAPI($API_LOG_LEVEL);
        //Hard check
        $result = $FoxPostApi->createParcel($parcels);
        if ($result == false /*|| $FoxPostApi->error==true*/) {
            //log_e($FoxPostApi->error_msg);
            //print_r($FoxPostApi->error_msgs);exit('ERROR');
            foreach ($FoxPostApi->error_msgs as $order_id => $error) {
                $package = FPPackage::getFPPackageByOrderId($order_id);
                $package->error = pSQL($error);
                $package->update();
            }

            $message[] = $FoxPostApi->error_msg;
            //return false;
        } else {
            //print_r($result);exit('OK');
            foreach ($result as $order_id => $tracking_number) {
                $package    = FPPackage::getFPPackageByOrderId($order_id); //print_r($package);exit;

                $package->error = '';
                $package->barcode = pSQL($tracking_number);
                $package->status = 1;
                $package->update();
            }
        }

        return $result;
    }


    /**
     * Make FoxApi compatible array from WooCommerce order object
     * 
     * 
     * 
     * 
     */
    public static function convOrder2ParcelData($order)
    {

        $parcel = FPPackage::getShipmentInfoByOrderId($order->id);
        $address = new Address($order->id_address_delivery);
        $addressI = new Address($order->id_address_invoice);
        $customer = new Customer($address->id_customer);
        /*
    order
    [id_address_delivery] => 7                       
    [id_address_invoice] => 7
    [id_customer] => 3
*/
        //print_r($customer);print_r($address);print_r($order);print_r($parcel);exit;

        $data = array();

        //uniqueBarcode

        if ('ps_cashondelivery' == $order->module) $data['cod'] = (int)$order->total_paid;
        $data['deliveryNote'] = substr($order->note, 0, 50);
        $data['recipientAddress'] = $address->address1 . ' ' . $address->address2;
        $data['recipientCity'] = $address->city;
        $data['recipientEmail'] = $customer->email;
        $data['recipientPhone'] = ('' != $address->phone_mobile) ? $address->phone_mobile : $address->phone;
        $data['recipientZip'] = $address->postcode;
        $data['comment'] =   Configuration::get('PS_SHOP_DOMAIN') . ' #' . $order->reference;       //PS_SHOP_DOMAIN_SSL
        $data['refCode'] = $order->id;

        $data['recipientName']  = ('' != $address->firstname) ? $address->firstname : $customer->firstname;
        $data['recipientName'] .= ' ';
        $data['recipientName'] .= ('' != $address->lastname) ? $address->lastname : $customer->lastname;

        if ('APM' == $parcel['shipping_method']) {
            $data['destination'] = $parcel['operator_id'];
        } else {
            //$data['recipientName'] .= ' ';
            //$data['recipientName'] .= (!empty($order->get_shipping_company())) ? $order->get_shipping_company() : $order->get_billing_company();
        }

        $data['size'] = $parcel['parcel_size'];
        $data['source'] = 'prestashop_' . _PS_VERSION_;
        //print_r($data);exit;     

        if (empty($data['recipientPhone'])) $data['recipientPhone'] = "+36701234567";

        return $data;
    }


    //Hosszúság (L) x Szélesség (W) x Magasság (H)
    public static function getParcelSizes()
    {

        return array(

            'XS' => array(
                'weight'    => 5,
                'length'    => 4.5 / 100,
                'width'     => 36 / 100,
                'height'    => 53 / 100,

            ),
            'S' => array(
                'weight'    => 15,
                'length'    => 11.5 / 100,
                'width'     => 36 / 100,
                'height'    => 61 / 100,
            ),
            'M' => array(
                'weight'    => 25,
                'length'    => 19.5 / 100,
                'width'     => 36 / 100,
                'height'    => 61 / 100,
            ),
            'L' => array(
                'weight'    => 25,
                'length'    => 37.5 / 100,
                'width'     => 36 / 100,
                'height'    => 61 / 100,
            ),
            'XL' => array(
                'weight'    => 25,
                'length'    => 60 / 100,
                'width'     => 36 / 100,
                'height'    => 61 / 100,
            ),

        );
    }


    /**
     * Append get params to a query string of the url
     *
     * @param string $url_string
     * @param array $query
     * @param bool $not_stringify
     * @return string|array
     */
    public static function appendQueryToUrl($url_string, $query = array(), $not_stringify = false)
    {
        $url = parse_url($url_string);
        $url['query'] = isset($url['query']) ? $url['query'] : '';
        parse_str($url['query'], $old_query);
        $url['query'] = http_build_query($old_query + $query, PHP_QUERY_RFC1738);

        if ($not_stringify) {
            return $url;
        }

        return self::stringifyUrl($url);
    }

    /**
     * Url to string
     *
     * @param $parsed_url
     * @return string
     */
    public static function stringifyUrl($parsed_url)
    {
        $scheme = isset($parsed_url['scheme']) ? $parsed_url['scheme'] . '://' : '';
        $host = isset($parsed_url['host']) ? $parsed_url['host'] : '';
        $port = isset($parsed_url['port']) ? ':' . $parsed_url['port'] : '';
        $user = isset($parsed_url['user']) ? $parsed_url['user'] : '';
        $pass = isset($parsed_url['pass']) ? ':' . $parsed_url['pass'] : '';
        $pass = ($user || $pass) ? "$pass@" : '';
        $path = isset($parsed_url['path']) ? $parsed_url['path'] : '';
        $query = isset($parsed_url['query']) ? '?' . $parsed_url['query'] : '';
        $fragment = isset($parsed_url['fragment']) ? '#' . $parsed_url['fragment'] : '';

        return "$scheme$user$pass$host$port$path$query$fragment";
    }


    public static function getLastParcelSyncTime()
    {

        $lastsyncfile = _PS_MODULE_DIR_ . 'foxpost' . DIRECTORY_SEPARATOR . 'logs' . DIRECTORY_SEPARATOR . 'last_api.sync';
        if (!file_exists($lastsyncfile)) {
            file_put_contents($lastsyncfile, 0);
            return 0;
        };

        return file_get_contents($lastsyncfile);
    }

    public static function setLastParcelSyncTime()
    {

        $lastsyncfile = _PS_MODULE_DIR_ . 'foxpost' . DIRECTORY_SEPARATOR . 'logs' . DIRECTORY_SEPARATOR . 'last_api.sync';
        file_put_contents($lastsyncfile, time());

        return true;
    }

    public static function check_if_sync_needed()
    {
        if (FPHelper::getLastParcelSyncTime() + (FoxPost::SYNC_MIN_MINUTE * 60) < time()) return true;
        return false;
    }






    /**
     * 
     * cron|admin
     *
     * @return int 0-nothing-to-do, 1-run-ok, 2:run-error
     */
    public function updateParcelState($mode = 'cron')
    {

        $need_sync = self::check_if_sync_needed();
        if (!$need_sync) {
            $this->log('check_if_sync_needed is FALSE');
            return 0;
        }

        $config = include(_PS_MODULE_DIR_ . 'foxpost/config.php');

        if (!isset($config['FoxpostParcelStatusToOrderStatus']['READY']) || !is_array($config['FoxpostParcelStatusToOrderStatus']['READY'])) {
            $this->log('Config error! In config.php FoxpostParcelStatusToOrderStatus.READY is missing! Sync not available! Exit, die, halt.');
            return 0;
        }

        $status_map = Configuration::get('FOXPOST_STATUS');
        if ($status_map == false) {
            $this->log('FOXPOST_STATUS map empty.', 7);
            //return 0; 
        }
        $status_map = (array)json_decode($status_map);     //print_r($status_map);
        $this->log('Status change map entry: ' . count($status_map));

        //$need = array();
        //foreach ($statuses as $fox=>$presta) if ( (int)$presta>0 ) $need[]=$fox;
        $need = $config['FoxpostParcelStatusToOrderStatus']['READY'];

        $SQL_array = "'" . implode("','", $need) . "'";     //print_r($SQL_array );
        $this->log('READY state is:' . $SQL_array);

        $values = \Db::getInstance()->executeS(
            "SELECT id_foxpost_package, id_order, barcode FROM `" . _DB_PREFIX_ . "foxpost_package` WHERE barcode<>'' AND (parcel_status NOT IN ($SQL_array) OR parcel_status IS NULL) ORDER BY id_order DESC"
        );
        //print_r($values);
        if (!$values) {
            $this->log('No parcel selecerd for check. Exit.');
            return 0;
        }
        $this->log(count($values) . ' parcel selecerd for check');
        /*
    [6] => Array
        (
            [id_foxpost_package] => 7
            [id_order] => 24
            [id_carrier] => 70
            [shipping_method] => APT
            [operator_id] => hu470
            [barcode] => CLFOX166957431043582
            [error] =>
            [parcel_status] =>
            [parcel_status_name] =>
            [active] => 1
            [exported] => 1
            [printed] => 1
            [status] => 2
            [date_add] => 2022-11-14 18:50:37
            [date_upd] => 2022-11-27 20:21:00
            [parcel_size] => XL
        )
                

stdClass Object
(
    [statusDate] => 2022-11-27T19:38:30
    [statusStationId] => 0
    [shortName] => Csomagod elkészült
    [longName] => Csomagod létrejött a rendszerünkben, a feladó még nem adta át azt a FOXPOST részére.
    [status] => CREATE
)

*/


        //$FoxPostApi = $this->module->getAPI(6);
        $FoxPostApi = $this->getAPI(7);
        foreach ($values as $value) {
            $fox_state = $FoxPostApi->parcelStatus($value['barcode']);      //print_r($fox_state);

            $parcel = new FPPackage($value['id_foxpost_package']);          //print_r($parcel);
            if ($fox_state == false) {
                //$this->log( 'API Error: '.$FoxPostApi->getLog() );
                $parcel->parcel_status      = '';
                $parcel->parcel_status_name = 'Ismeretlen csomaghiba';
                $parcel->update();
                $this->log('#' . $value['id_order'] . ' order: Unknown parcel error! Drop.');
                $FoxPostApi->reset();
                continue;
            }


            if ($fox_state->status != $parcel->parcel_status) {  //gogo
                $this->log('#' . $value['id_order'] . ' order ' . $value['barcode'] . ' has new state: ' . $fox_state->status);

                $parcel->parcel_status      = pSQL(trim($fox_state->status));
                $parcel->parcel_status_name = pSQL(trim($fox_state->shortName));
                $parcel->update();

                $this->log('Parcel data updated.');


                //Order status change
                if (isset($status_map[$fox_state->status]) && (int)$status_map[$fox_state->status] > 0) {
                    $new_status = (int)$status_map[$fox_state->status];

                    //HOOK???
                    $order = new Order((int)$value['id_order']);
                    $order->setCurrentState($new_status/*, Context::getContext()->employee->id*/);
                    //$order->update();
                    $this->log('Order data updated to state: ' . $new_status);
                } else {
                    $this->log('This state is not triggered by config.');
                }
            } else {
                $this->log('#' . $value['id_order'] . ' order state not changed.');
            }
            //if ($mode=='cron') 
            $FoxPostApi->reset();
        }

        FPHelper::setLastParcelSyncTime();


        return 1;
    }



    public function log($msg = '', $level = 2)
    {
        if ($msg != '') $this->logs[] = $msg;
        return implode("\n", $this->logs);
        //echo "$msg\n";
    }

    public static function getStringFromArray($log_array, $format = '%s ', $sep = '<br/>')
    {
        $string = '';
        if (is_array($log_array)) foreach ($log_array as $key => $value) $string .= sprintf($format, $key) . ': ' . $value . $sep;
        return $string;
    }
}
