<?php

use Symfony\Component\HttpFoundation\Session\Session;

/**
 * FoxPost official plugin
 *
 * @author Foxpost <kovago.balazs@foxpost.hu>
 * @copyright 2022 FoxPost Zrt.
 * @license   See joined file licence.txt
 * @category  Module
 * @support   Support <b2chelpdesk@foxpost.hu>
 * @version   0.0.1
 * @link      https://www.foxpost.hu
 * @see       https://devdocs.prestashop-project.org/1.7/modules/concepts/controllers/front-controllers/
 */

if (!defined('_PS_VERSION_')) exit;

class FoxPostFrontModuleFrontController extends ModuleFrontController
{
    private $session;

    public function __construct()
    {
        parent::__construct();
        // Do your stuff here
        //echo "FoxPostFrontModuleFrontController ";   exit;  
    }

    /**
     * @see FrontController::postProcess()
     */
    public function postProcess()
    {   //echo 'postProcess ';   // exit;  

    }

    public function initContent()
    {
        //echo "initContent "; exit('NEMEOM');  
        //echo Context::getContext()->link->getPageLink('foxpost');        
        //echo $this->context->link->getModuleLink('foxpost', 'front', ['ajax' => 1], false);

        $CodFeeProdId   = (int)Configuration::get('FOXPOST_CODFEE_PROD');
        $limit          = (int)Configuration::get('FOXPOST_CODFEE_LIMIT');

        if (Tools::getIsset('ajax') && Tools::getIsset('operator_id')) {
            $this->ajax = true;
            $this->context->cookie->__set('fx_operator_id', Tools::getValue('operator_id'));
            die(Tools::jsonEncode(['error' => false]));
        }


        if (Tools::getIsset('ajax') && Tools::getIsset('fxfee')) {
            $this->ajax = true;
            $cart = new Cart((int)Context::getContext()->cart->id);
            //print_r( $cart->getOrderTotal(true, Cart::BOTH_WITHOUT_SHIPPING) );


            $product = new Product($CodFeeProdId);
            if (!Validate::isLoadedObject($product)) {
                $this->module->log_e("FOXPOST_CODFEE_PROD product not exist with id #$CodFeeProdId !");
                die(Tools::jsonEncode(['error' => true]));
            }

            //Not FoxPost shippment selected
            if ($this->module->isMyCarrier($cart->id_carrier) == false) { //APM|HD|false
                $update = $cart->updateQty(0, $CodFeeProdId);
                die(Tools::jsonEncode(['error' => (bool)!$update]));
            }


            //$ps = $cart->getProducts(true, $fxcodfee);
            $cod_prod_in_basket = (int)$cart->getProductQuantity($CodFeeProdId)['quantity'];
            $basket_value = $cart->getOrderTotal(true, Cart::BOTH_WITHOUT_SHIPPING);
            if ($cod_prod_in_basket > 0) $basket_value = $basket_value - ($cod_prod_in_basket * $product->getPrice());
            //echo $basket_value;


            $fxfee = Tools::getValue('fxfee');
            if ((int)$basket_value >= (int)$limit) $fxfee = 'del';


            $cart = new Cart((int)Context::getContext()->cart->id);
            if (!Validate::isLoadedObject($cart))
                die(Tools::jsonEncode(['error' => true]));

            $update = false;
            if ($fxfee == 'add' && $cod_prod_in_basket < 1) {
                $update = $cart->updateQty(1, $CodFeeProdId);
            }
            if ($fxfee == 'del' && $cod_prod_in_basket > 0) {
                $update = $cart->updateQty(0, $CodFeeProdId);
            }

            die(Tools::jsonEncode(['error' => (bool)!$update]));
        }




        //exit;      
        //die(Tools::jsonEncode( ['error'=>true] ));  
        //parent::initContent();
        //$this->setTemplate('module:foxpost/views/templates/front/front.tpl');
    }
    public function setMedia()
    {
        //echo "setMedia "; 
        return;

        parent::setMedia();
        Media::addJsDef([
            'fx_link2' => $this->context->link->getModuleLink('foxpost', 'front', ['ajax' => 1], true),
            //'https://prestashop.devwing.hu/module/foxpost/front?ajax=1';
        ]);

        $this->context->controller->registerJavascript(
            'front-carrier',
            'module:foxpost/views/js/front-carrier.js',
            ['position' => 'bottom', 'inline' => false, 'priority' => 50,]
        );
    }
}
