<?php

use Symfony\Component\Filesystem\Filesystem;
use PrestaShop\PrestaShop\Adapter\ServiceLocator;
use PrestaShop\PrestaShop\Core\Domain\Address\Command\EditOrderAddressCommand;
use Module as LegacyModule;



/**
 * Foxpost official plugin
 * 
 * Csomagszállítás egyszerűen, rugalmasan, környezettudatosan és érintkezésmentesen.
 *                           
 * @author Foxpost <kovago.balazs@foxpost.hu>
 * @version 0.1.7
 */

if (!defined('_PS_VERSION_')) exit;

require_once(dirname(__FILE__) . '/src/FoxPostApi.php');
require_once(dirname(__FILE__) . '/classes/FPHelper.php');
require_once(dirname(__FILE__) . '/classes/FPPackage.php');

/**
 * FOXPOST_APM,FOXPOST_HD tartalamzza a telepítéskori Szállító IDkat, a FOXPOST_CARRIER_IDS pedig MINDEN későbbi változatét
 * 
 * 
 * 
 */

class FoxPost extends Module
{

    public static $conf_prefix = 'FOXPOST_';

    const COD_PROD_REF = 'fxcodfee';
    const DEFAULT_PARCEL_SIZE = 'S';
    const SYNC_MIN_MINUTE = 60;

    private $logger;
    private $FoxPostApi = null;
    private $API_LOG_LEVEL = 5;



    /**
     * not used yet
     * 
     */
    private static $defaults = array(
        'zone' => 'Europe',
        'fees' => array('Europe' => array('0|20000' => 1250, '20000|1000000' => 0)),
    );
    protected $statuses_array = array();
    /** @var string $translate_function Determines the function used for translate strings, based on version */
    private $translate_function = "l";
    public function __construct()
    {
        $this->name = 'foxpost';
        $this->tab = 'shipping_logistics';
        $this->version = '0.1.7';
        $this->author = 'Foxpost';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = [
            'min' => '1.7.7',
            'max' => '8.99.99', //_PS_VERSION_,
        ];
        $this->bootstrap = true;

        $this->controllers = ['front', 'cron', 'AdminFoxPostOrder', 'AdminFoxPost'];

        $this->translate_function = version_compare(_PS_VERSION_, '8.0.0', '<') ? "l" : "trans";

        parent::__construct();

        $this->displayName = $this->{$this->translate_function}('FOXPOST - Packeta Group');
        $this->description = $this->{$this->translate_function}('Csomagszállítás egyszerűen, rugalmasan, környezettudatosan és érintkezésmentesen.');
        $this->confirmUninstall = $this->{$this->translate_function}('Are you sure you want to uninstall this module?');

        $this->logger = ServiceLocator::get('\\PrestaShop\\PrestaShop\\Adapter\\LegacyLogger');

        $this->API_LOG_LEVEL = Configuration::get('FOXPOST_API_LOG_LEVEL');
        if (_PS_MODE_DEV_ == true) $this->API_LOG_LEVEL = 6;
        /*
        $this->log_a('alert');
        $this->log_e('error');  
        $this->log_w('warning');         
        $this->log_d('debug'); 
        */


        //temporary place
        //$this->uninstallTab('AdminFoxPostOrder');
        //$this->uninstallTab('AdminFoxPost');
        //$this->registerHook('actionAdminOrdersTrackingNumberUpdate');        


        /*       
        $this->tabs = [
            [
                'route_name' => 'admin_link_block_list',
                'class_name' => 'AdminFoxPostOrder',
                'visible' => true,
                'name' => 'AdminFoxPostOrder',
                'parent_class_name' => 'AdminParentShipping',
                'wording' => 'Admin FoxPost Order',
                'wording_domain' => 'Modules.FoxPost.Admin'
            ],
             [
                'route_name' => 'admin_link_block_list2',
                'class_name' => 'AdminFoxPost',
                'visible' => false,
                'name' => 'AdminFoxPost',
                'parent_class_name' => 'AdminParentShipping',
                'wording' => 'Admin FoxPost',
                'wording_domain' => 'Modules.FoxPost.Admin'
            ],
 
        ];   
*/
    }

    public function install()
    {
        $this->log_w('install');
        Configuration::updateGlobalValue(self::$conf_prefix . 'VERSION', $this->version);
        Configuration::updateGlobalValue(self::$conf_prefix . 'STATE', 'INSTALLING');


        $return = true;
        $return &= parent::install();

        $return &= $this->installCarriers();
        $return &= $this->createDbTables();
        $return &= $this->registerHook('displayAdminOrder');
        $return &= $this->registerHook('displayOrderConfirmation');
        $return &= $this->registerHook('displayAdminListBefore');
        $return &= $this->registerHook('displayCarrierExtraContent');
        $return &= $this->registerHook('displayBackOfficeHeader');      //CSS,JS   

        $return &= $this->registerHook('actionCarrierUpdate');
        $return &= $this->registerHook('actionValidateStepComplete');
        $return &= $this->registerHook('actionEmailSendBefore');
        $return &= $this->registerHook('actionFrontControllerSetMedia');
        $return &= $this->registerHook('actionAdminOrdersTrackingNumberUpdate');

        $this->log_d('hooks created');
        //self::updateCarrierServiceCodes();

        $return &= $this->setDefaults();

        $module_tabs = Tab::getModuleTabList(); //print_r($module_tabs);
        if (!isset($module_tabs[Tools::strtolower('AdminFoxPostOrder')])) {
            $this->installTab('AdminFoxPostOrder', 'FOXPOST - Packeta Group', 'AdminParentShipping', true);
        }
        if (!isset($module_tabs[Tools::strtolower('AdminFoxPost')])) {
            $this->installTab('AdminFoxPost', 'FoxPostHidden', 'AdminParentShipping', false);
        }

        //$return &= $this->installTab('AdminFoxPost', 'FoxPost', 'AdminParentShipping', false);
        //$return &= $this->installTab('AdminFoxPostOrder', 'FoxPost', 'AdminParentShipping', true);

        if ((bool)$return == true) Configuration::updateGlobalValue(self::$conf_prefix . 'STATE', 'INSTALLED');

        return (bool)$return;
    }

    public function uninstall()
    {
        $this->log_w('uninstall');
        Configuration::updateGlobalValue(self::$conf_prefix . 'STATE', 'UNINSTALLING');

        $return = true;

        $return &= $this->uninstallTab('AdminFoxPost');
        $return &= $this->uninstallTab('AdminFoxPostOrder');

        $return &= $this->uninstallCarriers();
        Configuration::deleteByName(self::$conf_prefix . 'VERSION');
        Configuration::deleteByName('FOXPOST_APM');
        Configuration::deleteByName('FOXPOST_HD');
        Configuration::deleteByName('FOXPOST_CARRIER_IDS');
        Configuration::deleteByName('FOXPOST_LABEL_SIZE');
        Configuration::deleteByName('FOXPOST_PARCEL_SIZE');
        Configuration::deleteByName('FOXPOST_COD_MODULE');
        Configuration::deleteByName('FOXPOST_CODFEE_PROD');
        Configuration::deleteByName('FOXPOST_CODFEE_LIMIT');
        Configuration::deleteByName('FOXPOST_CODFEE_VALUE');
        Configuration::deleteByName('FOXPOST_EMAIL_MSG');
        Configuration::deleteByName('FOXPOST_RELABEL');
        Configuration::deleteByName('FOXPOST_REPARCEL');
        Configuration::deleteByName('FOXPOST_API_LOG_LEVEL');


        if (_PS_MODE_DEV_ != true) {
            Configuration::deleteByName('FOXPOST_USER');
            Configuration::deleteByName('FOXPOST_PASS');
            Configuration::deleteByName('FOXPOST_API');
            Configuration::deleteByName('FOXPOST_STATUS');
        }

        if (parent::uninstall() === false) {
            return false;
        }



        Configuration::updateGlobalValue(self::$conf_prefix . 'STATE', 'UNINSTALLED');
        return $return;
    }


    private function setDefaults()
    {
        $config = include('config.php');
        $product_id = 0;

        //Nem telepítjük ha nem kell
        $CODFee = (float)$config['FoxpostParcelCODFeeDefauts'][1];
        if ($CODFee > 0) {
            $product_id = Product::getIdByReference(self::COD_PROD_REF);
            if ($product_id == false) {
                $product_id = $this->addCODProd($CODFee, self::COD_PROD_REF);
                $this->log_d("CODFee product added[#$product_id]!");
            } else {
                $product = new Product($product_id);
                $product->price = number_format($CODFee, 0, '.', '');
                $product->update();
                $this->log_w("CODFee product[#$product_id] exist! updated");
            }
        }


        Configuration::updateGlobalValue(self::$conf_prefix . 'COD_MODULE', 'ps_cashondelivery');
        Configuration::updateGlobalValue(self::$conf_prefix . 'CODFEE_PROD', $product_id);
        Configuration::updateGlobalValue(self::$conf_prefix . 'CODFEE_LIMIT', $config['FoxpostParcelCODFeeDefauts'][0]);
        Configuration::updateGlobalValue(self::$conf_prefix . 'CODFEE_VALUE', $config['FoxpostParcelCODFeeDefauts'][1]);
        Configuration::updateGlobalValue(self::$conf_prefix . 'REPARCEL', 0);
        Configuration::updateGlobalValue(self::$conf_prefix . 'RELABEL', 1);
        Configuration::updateGlobalValue(self::$conf_prefix . 'EMAIL_MSG', '');
        Configuration::updateGlobalValue(self::$conf_prefix . 'API_LOG_LEVEL', 5);
        Configuration::updateGlobalValue(self::$conf_prefix . 'DEBUG', 0);


        $this->log_w("default values added");

        return true;
    }


    public function hookActionAdminOrdersTrackingNumberUpdate($param)
    {
        if (self::isMyCarrier((int)$param['carrier']->id_reference)) {
            //echo "hookActionAdminOrdersTrackingNumberUpdate"    ;
            $tracking_numer = $param['order']->shipping_number;
            $fox = FPPackage::getFPPackageByOrderId((int)$param['order']->id);    //var_dump($tracking_numer);
            $fox->barcode = $tracking_numer;
            $fox->update();
            $fox->save();
        }
        //exit;   
    }

    public function hookActionEmailSendBefore($param)
    {
        if (!isset($param['templateVars']) || !isset($param['templateVars']['{id_order}'])) {
            return;
        }

        $tpl_name = (string) $param['template'];
        $id_lang  = (int) $param['idLang'];
        $orderId  = (int) $param['templateVars']['{id_order}'];

        $parcel = FPPackage::getFPPackageByOrderId($orderId);
        if (!$parcel || empty($parcel->barcode)) {
            return;
        }

        $url = sprintf(FoxPostApi::TRACEURL, $parcel->barcode);
        if (isset($param['templateVars']['{message}']))
            $param['templateVars']['{message}'] .= "<br/><br/>\n\n" . self::getConfig('EMAIL_MSG', '') . "<br/>\n" . ' <a href="' . $url . '">' . $this->{$this->translate_function}('Package tracking') . '</a>';
        //print_r($param);  exit();                
    }

    public function hookActionFrontControllerSetMedia()
    {
        Media::addJsDef([
            'fx_link'       => $this->context->link->getModuleLink('foxpost', 'front', ['ajax' => 1], true),
            'fx_cartlink'   => Context::getContext()->link->getPageLink('cart', true, null, ['ajax' => '1', 'action' => 'refresh'], false),
            'fx_codmodule'  => self::getConfig(self::$conf_prefix . 'COD_MODULE', 'ps_cashondelivery'),
        ]);
        /*
        $this->context->controller->registerStylesheet(
            'front-css',
            'modules/' . $this->name . '/views/dist/front.css'
        ); */

        $this->context->controller->registerJavascript(
            'front-carrier',
            $this->_path . 'views/js/front-carrier.js',
            ['position' => 'bottom', 'inline' => false, 'priority' => 50,]
        );
    }


    /**
     * Check if the locker is selected in Front Office
     * 
     * This hook is called on checkout page, when confirming delivery section.
     * Carrier modules that display extra content to the customer can hook here and prevent him from advancing further, 
     * if he didn’t enter required information.
     * 
     */
    public function hookActionValidateStepComplete($params)
    {
        //print_r( $params ); echo "hookActionValidateOrder ";//exit;           

        $service_name = $this->isMyCarrier((int) $params['cart']->id_carrier);
        if ($params['step_name'] == 'delivery' && $service_name == 'APM' && $this->active) {

            if (empty($params['request_params']['fx_apm_list'])) {
                $this->context->controller->errors[] = $this->{$this->translate_function}('FOXPOST - Packeta Group delivery: Please select a parcel locker!');
                $params['completed']  = false;

                //$params['completed']  = false; in NOT ENOUGHT
                $customer = new Customer((int) $params['cart']->id_customer);
                Tools::redirect($this->context->link->getPageLink(
                    'order',
                    true,
                    (int) $this->context->language->id,
                    [
                        'id_cart' => (int) $params['cart']->id,
                        'id_module' => (int) $this->id,
                        'key' => $customer->secure_key,
                    ]
                ) . '#fx_warning');
            }
        }
        $params['completed'] = true;
        return;
    }


    public function hookActionCarrierUpdate($carrier)
    {
        //print_r($carrier); exit;  
        $this->updateCarrierServiceCodes();
    }


    /**
     * Show FoxPost delivery extra select box
     * 
     */
    public function hookDisplayCarrierExtraContent($carrier)
    {

        $service_name = $this->isMyCarrier((int)$carrier['carrier']['id']);
        if ($service_name != 'APM') return '';
        $html = "";

        //include_once(_PS_MODULE_DIR_.'foxpost/controllers/front/front.php');
        //$front = new FoxPostFrontModuleFrontController();
        //$html = $front->initContent();

        //define('_PS_CACHE_DIR_', _PS_ROOT_DIR_.'/var/cache/' . _PS_ENV_ . DIRECTORY_SEPARATOR);
        $file = 'foxplus.json';
        if (!Tools::isFileFresh('/var/cache/' . _PS_ENV_ . DIRECTORY_SEPARATOR . $file, 86400)) {
            $this->log_d('download: ' . FoxPostApi::APMJSON);
            $filesize = Tools::copy(FoxPostApi::APMJSON, _PS_CACHE_DIR_ . $file);
        }
        $apmData = json_decode(file_get_contents(_PS_CACHE_DIR_ . $file));

        $locale = str_replace('-', '_', Context::getContext()->language->locale);
        $currentLocale = setlocale(LC_COLLATE, 0);
        setlocale(LC_COLLATE, "$locale.utf8");
        usort($apmData, function ($a, $b) {
            return strcoll($a->city . $a->name, $b->city . $b->name);
        });
        setlocale(LC_COLLATE, $currentLocale);


        $context = Context::getContext();
        usort($apmData, function($a, $b){
            return strcmp($a->name, $b->name);
        });
        $apms = [
            ...array_values(array_filter($apmData, function ($item){
                return preg_match('/FOXPOST\ Bp/', $item->name);
            })),
            ... array_values(array_filter($apmData, function ($item){
                return !preg_match('/FOXPOST\ Bp/', $item->name);
            })),
        ];
        $this->context->smarty->assign([
            'fx_apms'            => $apms,
            'fx_apm_selected'    => $context->cookie->fx_operator_id,
            //'fx_url'             => $this->context->link->getModuleLink('foxpost', 'front', ['ajax' => 1], true),
        ]);
        //$this->setTemplate('module:foxpost/views/templates/front/my-front-template.tpl');
        //$html .= $this->display(__FILE__, 'module:foxpost/views/templates/front/my-front-template.tpl');

        $html .= $this->display(__FILE__, 'after.tpl');
        return $html;
    }


    public function hookDisplayOrderConfirmation($param)
    {
        //echo 'hookDisplayOrderConfirmation';
        $oid = $param['order']->id;
        $cid = $param['order']->id_carrier;
        $is_my_job = self::isMyCarrier($param['order']->id_carrier);
        $ps = self::getConfig('PARCEL_SIZE', self::DEFAULT_PARCEL_SIZE);

        if ($is_my_job == false) return;

        try {
            $insert = "INSERT INTO " . _DB_PREFIX_ . "foxpost_package SET 
                    id_order='" . pSQL($oid) . "', id_carrier='" . pSQL($cid) . "', active=1, 
                    shipping_method='" . pSQL($is_my_job) . "', parcel_size='" . pSQL($ps) . "', date_add=NOW()";

            if ($is_my_job == 'APM') {
                $context = Context::getContext();
                if (empty($context->cookie->fx_operator_id) || is_null($context->cookie->fx_operator_id)) {
                    $this->log_e('FoxPost: APM operator_id not selected');
                    return;
                    //ez nem jó    
                }
                $operator_id = $context->cookie->fx_operator_id; //'hu470';
                $insert .= ", operator_id='" . pSQL($operator_id) . "' ";
            }


            \Db::getInstance()->query($insert);
        } catch (Exception $e) {
            $this->log_w('This is normal, NOT error:' . $e->getMessage());
        }
        //print_r($param['order']); exit;    
    }


    public function hookDisplayAdminListBefore($params)
    {
        if ($this->context->controller->controller_name != 'AdminFoxPostOrder') return '';
        $html = '';
        $this->context->controller->addCSS($this->_path . 'views/css/admin-order.css');


        $this->context->smarty->assign(array(
            'formlink' => $this->context->link->getAdminLink('AdminFoxPostOrder'),
            /*
            'formlink' => FPHelper::appendQueryToUrl(
                    $this->context->link->getAdminLink('AdminFoxPostOrder'),
                    //array('id_order' => '',)
                    ),
             */
            'lastsync' => (FPHelper::getLastParcelSyncTime() > 0) ? date(Context::getContext()->language->date_format_lite . ' H:i', FPHelper::getLastParcelSyncTime())
                : '-',
        ));


        $html .= $this->display(
            __FILE__,
            'views/templates/admin/foxpost-order.tpl'
        );

        return $html;
    }

    public function hookDisplayBackOfficeHeader($params)
    {

        if ($this->context->controller->controller_name != 'AdminOrders') return '';
        $this->context->controller->addJquery();
        $this->context->controller->addJS($this->_path . 'views/js/admin-order.js');
        $this->context->controller->addCSS($this->_path . 'views/css/admin-order.css');

        return '';
    }

    public function hookDisplayAdminOrder($params)
    {
        $id_order = (int)$params['id_order'];
        $html = '';

        //$this->ajax = true;
        $order = new Order($id_order);

        if (!Validate::isLoadedObject($order)) {
            return '';
        }

        //$isMyJob = self::isMyCarrier($order->id_carrier);
        //$isMyJob = self::getShipmentInfo($id_order); 
        $isMyJob = FPPackage::getShipmentInfoByOrderId($id_order);
        if ($isMyJob == false) return;


        //$parcels = $this->sanitazeData($datas);//    print_r($parcels);exit;

        //echo "hookDisplayAdminOrder EZ bezony FOXPOST";//print_r($carrier_codes);
        //var_dump($isMyJob);exit;
        $this->context->smarty->assign(array(
            'order' => $order,
            'parcel' => $isMyJob,
            'carrier' => (array)new Carrier($order->id_carrier),
            'tracking_url' => sprintf(FoxPostApi::TRACEURL, $isMyJob['barcode']),
            'parcel_sizes' => array_combine(array_keys(FPHelper::getParcelSizes()), array_keys(FPHelper::getParcelSizes())),
            'module_version' => $this->version,
            'module_name' => $this->name,
            'link' => FPHelper::appendQueryToUrl(
                $this->context->link->getAdminLink('AdminFoxPost'),
                array(
                    //'ajax' => '1',
                    //'action' => 'createLabel',    //false ? 'printLabel' : 
                    'id_order' => $id_order,
                )
            ),

        ));


        //$a = new EditOrderAddressCommand($id_order, PrestaShop\PrestaShop\Core\Domain\Order\OrderAddressType::DELIVERY_ADDRESS_TYPE);  
        //$a = PrestaShop\PrestaShop\Adapter\Address\QueryHandler\GetCustomerAddressForEditing($order->id_address_delivery);     
        //$a = $a->getQueryBus()->handle(new GetCustomerAddressForEditing((int) $order->id_address_delivery));
        //$a = new Address((int) $order->id_address_delivery);
        //print_r( $a );exit;


        $html .= $this->display(
            __FILE__,
            'views/templates/admin/order/admin-carrier.tpl'
        );

        return $html;
    }
    /*
    public static function getShipmentInfo($id_order){
    
        return Db::getInstance()->getRow(
            'SELECT * FROM `'._DB_PREFIX_.'foxpost_package` WHERE `id_order`= '.(int)$id_order.' AND deleted=0'
        );
    
    }
*/


    /**
     * ReFress FOXPOST_CARRIER_IDS
     * Save ALL IDs!
     *
     * @return array
     */
    public static function updateCarrierServiceCodes()
    {
        //$this->log_d('updateCarrierServiceCodes');
        $carrier_codes = array();

        foreach (array_keys(self::getServicesNames()) as $service_code) {
            $id_reference = Configuration::get(self::$conf_prefix . $service_code);
            //echo "*$id_reference*";

            $values = \Db::getInstance()->executeS(
                'SELECT `id_carrier` FROM `' . _DB_PREFIX_ . 'carrier`
    			WHERE id_reference = ' . (int) $id_reference . ' ORDER BY id_carrier DESC'
            );  // AND deleted = 0
            if (!$values)  continue;

            foreach ($values as $value) {
                $carrier_codes[$value['id_carrier']] = $service_code;
            }
        }
        //var_dump($carrier_codes);   exit; 

        Configuration::updateValue('FOXPOST_CARRIER_IDS', json_encode($carrier_codes));

        return $carrier_codes;
    }

    public static function isMyCarrier($id_carrier)
    {
        $carrier_codes = self::getCarrierServiceCodes();

        if (isset($carrier_codes[$id_carrier])) {
            return $carrier_codes[$id_carrier];
        }
        return false;
    }

    /**
     * Get mapping from configuration
     *
     * @return mixed
     */
    public static function getCarrierServiceCodes()
    {
        $carrier_codes = json_decode(Configuration::get('FOXPOST_CARRIER_IDS'), true);
        return $carrier_codes;
    }

    /** Module configuration page */
    public function getContent()
    {
        $html = '<b>Hivatalos FoxPost modul konfigurációs oldala</b>';
        $view_mode = Tools::getValue('view');
        //echo  " getContent: $view_mode, ";

        switch ($view_mode) {
            case 'information':
                $definition_pages = $this->getDefinitionConfigurePages();
                $html .= $this->displayMenu($definition_pages);
                //$html .= $this->displayInfo();
                break;
            case 'changelog':
                $changelog_file = dirname(__FILE__) . '/Readme.md';
                if (file_exists($changelog_file)) {
                    die($this->displayChangelog($changelog_file));
                }
                break;
            case 'settings2':
                $definition_pages = $this->getDefinitionConfigurePages();
                $html .= $this->displayMenu($definition_pages);
                $html .= $this->displaySettings2Form();
                break;

            case 'settings3':
                $definition_pages = $this->getDefinitionConfigurePages();
                $html .= $this->displayMenu($definition_pages);
                $html .= $this->displaySettings3Form();
                break;

            case 'settings':
            default:
                $definition_pages = $this->getDefinitionConfigurePages();
                $html .= $this->displayMenu($definition_pages);
                $html .= $this->postProcess();
                $html .= $this->displaySettings1Form();
                break;
        }

        return $html;
    }


    protected function getFormFieldsSettings1()
    {
        //$form_fields = array();
        //   Tools::getAdminTokenLite('AdminModules');      

        $form_fields['form1'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->{$this->translate_function}('General settings'),     //Általános
                    'icon' => 'icon-circle'  //icon-truck//
                ),
                //'description' => sprintf( $this->{$this->translate_function}('After settings please edit and enable Foxpost carrier <a href="%s">there</a>.'), $this->context->link->getAdminLink('AdminCarriers')),
                'description' => $this->{$this->translate_function}('After settings please edit and enable Foxpost carrier under Shipping --> Carriers.'),
                'input' => array(
                    array(
                        'name'     => 'FOXPOST_USER',
                        'type'     => 'text',
                        'label'    => $this->{$this->translate_function}('Foxpost API username'),
                        'desc'     => $this->{$this->translate_function}('If you provide a Foxpost API username you will be able to send parcels to Foxpost API.'),
                        'required' => true,
                        'form_group_class' => 'shipper_by_address'
                    ),
                    array(
                        'name'     => 'FOXPOST_PASS',
                        'type'     => 'text',
                        'label'    => $this->{$this->translate_function}('Foxpost API password'),
                        'desc'     => $this->{$this->translate_function}('If you provide a Foxpost API password you will be able to send parcels to Foxpost API.'),
                        'required' => true,
                        'form_group_class' => 'shipper_by_address'
                    ),
                    array(
                        'name'     => 'FOXPOST_API',
                        'type'     => 'text',
                        'label'    => $this->{$this->translate_function}('Foxpost API key'),
                        'desc'     => $this->{$this->translate_function}('If you provide a Foxpost API KEY you will be able to send parcels to Foxpost API.'),
                        'required' => true,
                        'form_group_class' => 'shipper_by_address'
                    ),
                    array(
                        'name' => 'FOXPOST_LABEL_SIZE',
                        'label' => $this->{$this->translate_function}('Label size'),
                        'desc' => $this->{$this->translate_function}('One label size on printed page.'),
                        'type' => 'select',
                        'options' => array(
                            'query' => array(
                                array('id' => 'A6', 'name' => 'A6'),
                                array('id' => 'A7', 'name' => 'A7'),
                                array('id' => '85x85mm', 'name' => '85x85mm'),
                            ),
                            'id' => 'id',
                            'name' => 'name',
                        ),
                    ),
                    array(
                        'name' => 'FOXPOST_PARCEL_SIZE',
                        'label' => $this->{$this->translate_function}('Default parcel size'),
                        'type' => 'select',
                        'hint' => '',
                        'desc' => '',
                        'options' => array(
                            'query' => $this->getParcelSizes(true),
                            'id' => 'id',
                            'name' => 'name',
                        ),
                    ),

                ),
                'submit' => array(
                    'title' => $this->{$this->translate_function}('Save'),
                    'name'  => 'submitSaveOptions',
                )
            )
        );

        return $form_fields;
    }
    protected function displaySettings1Form()
    {
        $helper = new HelperForm();
        $helper->required = false;
        $helper->id = null;
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->table = 'foxpost_configure';
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->module = $this;
        $helper->identifier = null;
        $helper->toolbar_btn = null;
        $helper->ps_help_context = null;
        $helper->title = null;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = false;
        $helper->bootstrap = true;

        $helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');

        //if (_PS_VERSION_ < '1.6.0.0') {
        $helper->show_toolbar = false;
        $helper->title = $this->displayName;
        //}

        $fields_value_keys = array('USER', 'PASS', 'API', 'LABEL_SIZE', 'PARCEL_SIZE');

        foreach ($fields_value_keys as $key) {
            $helper->fields_value[self::$conf_prefix . $key] = Tools::getValue(self::$conf_prefix . $key, self::getConfig($key));
        }
        $helper->fields_value['FOXPOST_PARCEL_SIZE'] = Tools::getValue('FOXPOST_PARCEL_SIZE', self::getConfig('PARCEL_SIZE', 'S'));
        $helper->fields_value['FOXPOST_LABEL_SIZE'] = Tools::getValue('FOXPOST_LABEL_SIZE', self::getConfig('LABEL_SIZE', 'A7'));


        $this->context->smarty->assign(
            array(
                'FOXPOST_API_VERSION' => FOXPOST_PHP_API_VERSION,
            )
        );

        //$string_val = pSQL(Tools::getValue('someValue'));
        return $helper->generateForm($this->getFormFieldsSettings1());
    }


    protected function displaySettings2Form()
    {

        $helper = new HelperForm();
        $helper->required = false;
        $helper->id = null;
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->table = 'foxpost_configure';
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->module = $this;
        $helper->identifier = null;
        $helper->toolbar_btn = null;
        $helper->ps_help_context = null;
        $helper->title = null;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = false;
        $helper->bootstrap = true;

        $helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');

        //if (_PS_VERSION_ < '1.6.0.0') {
        $helper->show_toolbar = false;
        $helper->title = $this->displayName;
        //}

        $fields_value_keys = array('');

        foreach ($fields_value_keys as $key)
            $helper->fields_value[self::$conf_prefix . $key] = Tools::getValue(self::$conf_prefix . $key, self::getConfig($key, null));

        $config = include('config.php'); //print_r($config );

        $saved = (array)json_decode(self::getConfig('STATUS', '{}'));
        foreach (($config['FoxpostParcelStatusToOrderStatus']) as $key => $v) {
            $name = (is_array($v)) ? $key : $config['FoxpostParcelStatusToOrderStatus'][$key];
            $s = (isset($saved[$name])) ? $saved[$name] : '';
            $helper->fields_value[self::$conf_prefix . "STATUS[$name]"] = Tools::getValue(self::$conf_prefix . "STATUS[$name]", $s);
        }

        $os = new OrderState();

        $form_fields['form2'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->{$this->translate_function}('Parcels and Orders'),
                    'icon' => 'icon-circle'  //icon-truck//
                ),
                //'description' => $this->{$this->translate_function}('Please select when, what, why'),
                'input' => array(),
                'submit' => array(
                    'title' => $this->{$this->translate_function}('Save'),
                    'name'  => 'submitSaveOptions2',
                )
            )
        );

        $input = array();
        foreach ($config['FoxpostParcelStatusToOrderStatus'] as $nameORid => $parcelstate) {
            $name = (is_array($parcelstate)) ? $nameORid : $config['FoxpostParcelStatusToOrderStatus'][$nameORid];
            $input[] =
                array(
                    'name' => self::$conf_prefix . "STATUS[$name]",
                    'label' => $this->{$this->translate_function}("FX_PARCEL_STATUS_$name"),
                    'hint' => $this->{$this->translate_function}("FX_PARCEL_STATUS_HINT_$name"),
                    'desc' => '',
                    'type' => 'select',
                    'options' => array(
                        'query' => array_merge(array(array('id_order_state' => '', 'name' => $this->{$this->translate_function}('Select or leave'))), $os->getOrderStates((int) $this->context->language->id)),
                        'id' => 'id_order_state',
                        'name' => 'name',
                    ),
                );
        }
        $form_fields['form2']['form']['input'] = $input;


        return $helper->generateForm($form_fields);
    }

    protected function displaySettings3Form()
    {

        $helper = new HelperForm();
        $helper->required = false;
        $helper->id = null;
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->table = 'foxpost_configure';
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->module = $this;
        $helper->identifier = null;
        $helper->toolbar_btn = null;
        $helper->ps_help_context = null;
        $helper->title = null;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = false;
        $helper->bootstrap = true;

        $helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');

        //if (_PS_VERSION_ < '1.6.0.0') {
        $helper->show_toolbar = false;
        $helper->title = $this->displayName;
        //}

        $fields_value_keys = array('EMAIL_MSG', 'RELABEL', 'REPARCEL');

        foreach ($fields_value_keys as $key)
            $helper->fields_value[self::$conf_prefix . $key] = Tools::getValue(self::$conf_prefix . $key, self::getConfig($key, null));


        $config = include('config.php'); //print_r($config );    

        $helper->fields_value[self::$conf_prefix . 'CODFEE_VALUE'] = Tools::getValue(self::$conf_prefix . 'CODFEE_VALUE', self::getConfig('CODFEE_VALUE', $config['FoxpostParcelCODFeeDefauts'][1]));
        $helper->fields_value[self::$conf_prefix . 'CODFEE_LIMIT'] = Tools::getValue(self::$conf_prefix . 'CODFEE_LIMIT', self::getConfig('CODFEE_LIMIT', $config['FoxpostParcelCODFeeDefauts'][0]));

        $helper->fields_value[self::$conf_prefix . 'DEBUG'] = (self::getConfig('API_LOG_LEVEL', 5) == 5) ? 0 : 1;

        /*


XXX	Ft alatt YY Ft


            'log'      => array(
                'title'   => Foxpost_Wc_Shipping::__('Log files'),             
                'type'    => 'button',
                'label'   => Foxpost_Wc_Shipping::__('See last logfile'),                   
                'id'      => 'foxpost_wc_shipping_viewlog',
                'default' => 'no',
                'value'   => '/wp-admin/admin.php?page=wc-status&tab=logs',
                'desc'    => sprintf('<a href="/wp-admin/admin.php?page=wc-status&tab=logs">%s</a>', Foxpost_Wc_Shipping::__('All log see on WooCommerce->Status->Logs tab.') ), 
            ),       
            
 */


        $form_fields['form3'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->{$this->translate_function}('Other settings'),
                    'icon' => 'icon-circle'  //icon-truck//
                ),
                //'description' => $this->{$this->translate_function}('Please select when, what, why'),                    
                'input' => array(
                    array(
                        'type'     => 'html',
                        'name'     => '<input name="' . self::$conf_prefix . 'CODFEE_LIMIT" value="' . $helper->fields_value[self::$conf_prefix . 'CODFEE_LIMIT'] . '"/> Ft alatt <input name="' . self::$conf_prefix . 'CODFEE_VALUE" value="' . $helper->fields_value[self::$conf_prefix . 'CODFEE_VALUE'] . '" /> Ft',
                        'label'    => $this->{$this->translate_function}('COD fee'),
                        'desc'     => $this->{$this->translate_function}('Fee when COD payment method selected.'),
                    ),

                    array(
                        'type'     => 'textarea',
                        'name'     => self::$conf_prefix . 'EMAIL_MSG',
                        'label'    => $this->{$this->translate_function}('Extra email message'),
                        'desc'     => $this->{$this->translate_function}('This message put into order email, after message. HTML is applicable.'),
                        'class'    => '',
                        'disabled' => false,
                    ),

                    array(
                        'type'     => 'switch',
                        'name'     => self::$conf_prefix . 'RELABEL',
                        'label'    => $this->{$this->translate_function}('Print label'),
                        'desc'     => $this->{$this->translate_function}('If enabled then available print PDF stickers more that once.'),
                        'class'    => '',
                        'is_bool'  => true,
                        'disabled' => false,
                        'values'   => array(
                            array('id' => 1, 'value' => 1),
                            array('id' => 0, 'value' => 0)
                        ),
                    ),

                    array(
                        'type'     => 'switch',
                        'name'     => self::$conf_prefix . 'REPARCEL',
                        'label'    => $this->{$this->translate_function}('Export CSV and send to Foxpost API'),
                        'desc'     => $this->{$this->translate_function}('If enabled then available to Foxpost API/CSV more that once.'),
                        'class'    => '',
                        'is_bool'  => true,
                        'disabled' => false,
                        'values'   => array(
                            array('id' => 1, 'value' => 1),
                            array('id' => 0, 'value' => 0)
                        ),
                    ),


                    array(
                        'type'     => 'switch',
                        'name'     => self::$conf_prefix . 'DEBUG',
                        'label'    => $this->{$this->translate_function}('Debug mode'),
                        'desc'     => $this->{$this->translate_function}('Enable or disable debug mode.'),
                        'class'    => '',
                        'is_bool'  => true,
                        'disabled' => false,
                        'values'   => array(
                            array('id' => 1, 'value' => 1),
                            array('id' => 0, 'value' => 0)
                        ),
                    ),
                    array(                          //$this->context->link->getModuleLink('foxpost', 'front', ['ajax' => 1], true),
                        'type'     => 'html',
                        'name'     => '<a href="' . $this->context->link->getAdminLink('AdminFoxPost', true, null, ['action' => 'DlLog', 'ajax' => 1, 'file' => date('Ymd', strtotime("-2 days"))]) . '" target="_blank">' . $this->{$this->translate_function}('Before yesterday') . '</a>,
                                       <a href="' . $this->context->link->getAdminLink('AdminFoxPost', true, null, ['action' => 'DlLog', 'ajax' => 1, 'file' => date('Ymd', strtotime("-1 days"))]) . '" target="_blank">' . $this->{$this->translate_function}('Yesterday') . '</a>,
                                       <a href="' . $this->context->link->getAdminLink('AdminFoxPost', true, null, ['action' => 'DlLog', 'ajax' => 1, 'file' => date('Ymd')]) . '" target="_blank">' . $this->{$this->translate_function}('Today') . '</a>
                        
                        ',
                        'label'    => $this->{$this->translate_function}('Log files'),
                        'desc'     => $this->{$this->translate_function}('Log files deleted after 14days!'),
                    ),



                    /*
                    array(
                        'type'     => 'switch',
                        'name'     => self::$conf_prefix.'ORDER_WEIGHT',
                        'label'    => $this->{$this->translate_function}('Enable calculating weight of package'),
                        'desc'     => $this->{$this->translate_function}('Enable calculating weight of package in according with weight of products in order'),
                        'class'    => '',
                        'is_bool'  => true,
                        'disabled' => false,
                        'values'   => array(
                            array('value' => 1),
                            array('value' => 0)
                        ),
                    ),                 
*/

                ),
                'submit' => array(
                    'title' => $this->{$this->translate_function}('Save'),
                    'name'  => 'submitSaveOptions3',
                )
            )
        );




        return $helper->generateForm($form_fields);
    }








    public function postProcess()
    {


        if (Tools::isSubmit('submitSaveOptions3')) {
            $form_errors = array();

            if (Tools::getIsset('FOXPOST_EMAIL_MSG') && Tools::strlen(Tools::getValue('FOXPOST_EMAIL_MSG')) > 255) {
                $form_errors[] = $this->_errors[] = $this->{$this->translate_function}('The FOXPOST_EMAIL_MSG is too long');
            }

            $LOG_LEVEL = (Tools::getValue('FOXPOST_DEBUG') == 1) ? 6 : 5;

            if (count($form_errors) == 0) {
                $result_save =
                    Configuration::updateValue('FOXPOST_API_LOG_LEVEL', $LOG_LEVEL) &&
                    Configuration::updateValue('FOXPOST_EMAIL_MSG',     $this->gV('FOXPOST_EMAIL_MSG')) &&
                    Configuration::updateValue('FOXPOST_CODFEE_VALUE',  $this->gV('FOXPOST_CODFEE_VALUE')) &&
                    Configuration::updateValue('FOXPOST_CODFEE_LIMIT',  $this->gV('FOXPOST_CODFEE_LIMIT')) &&
                    Configuration::updateValue('FOXPOST_RELABEL',       $this->gV('FOXPOST_RELABEL')) &&
                    Configuration::updateValue('FOXPOST_REPARCEL',      $this->gV('FOXPOST_REPARCEL'));
                if ($result_save == true) {
                    $this->_confirmations[] = $this->{$this->translate_function}('Settings updated');
                }
            }
        }


        if (Tools::isSubmit('submitSaveOptions2')) {
            $form_errors = array();
            Configuration::updateValue('FOXPOST_STATUS', json_encode(Tools::getValue('FOXPOST_STATUS')));
        }

        if (Tools::isSubmit('submitSaveOptions')) {
            $form_errors = array();


            if (Tools::getIsset('FOXPOST_USER') && Tools::strlen(Tools::getValue('FOXPOST_USER')) > 255) {
                $form_errors[] = $this->_errors[] = $this->{$this->translate_function}('The FOXPOST_USER is too long');
            }
            if (Tools::getIsset('FOXPOST_PASS') && Tools::strlen(Tools::getValue('FOXPOST_PASS')) > 255) {
                $form_errors[] = $this->_errors[] = $this->{$this->translate_function}('The FOXPOST_PASS is too long');
            }
            if (Tools::getIsset('FOXPOST_API') && Tools::strlen(Tools::getValue('FOXPOST_API')) > 255) {
                $form_errors[] = $this->_errors[] = $this->{$this->translate_function}('The FOXPOST_API is too long');
            }


            if (count($form_errors) == 0) {
                $old_u = Configuration::get('FOXPOST_USER');
                $old_p = Configuration::get('FOXPOST_PASS');
                $old_a = Configuration::get('FOXPOST_API');
                $result_save =
                    Configuration::updateValue('FOXPOST_USER', $this->gV('FOXPOST_USER')) &&
                    Configuration::updateValue('FOXPOST_PASS', $this->gV('FOXPOST_PASS')) &&
                    Configuration::updateValue('FOXPOST_API',  $this->gV('FOXPOST_API')) &&
                    Configuration::updateValue('FOXPOST_LABEL_SIZE', Tools::getValue('FOXPOST_LABEL_SIZE')) &&
                    Configuration::updateValue('FOXPOST_PARCEL_SIZE', Tools::getValue('FOXPOST_PARCEL_SIZE'));

                if ($result_save == true) {
                    $this->_confirmations[] = $this->{$this->translate_function}('Settings updated');
                    Configuration::updateGlobalValue(self::$conf_prefix . 'STATE', 'CONFIGURED');
                }


                //If chaged test it
                if (
                    $old_u !== Tools::getValue('FOXPOST_USER') ||
                    $old_p !== Tools::getValue('FOXPOST_PASS') ||
                    $old_a !== Tools::getValue('FOXPOST_API')
                ) {
                    Configuration::updateGlobalValue(self::$conf_prefix . 'STATE', 'TEST');

                    //$FoxPostApi = new FoxPostApi($username, $password, $apikey, 2);  
                    //$FoxPostApi = new FoxPostApi(6);                     
                    //$FoxPostApi->setTmpDir( dirname(__FILE__) . DIRECTORY_SEPARATOR . 'logs' . DIRECTORY_SEPARATOR . 'API' . DIRECTORY_SEPARATOR );
                    //$FoxPostApi->setCred(Configuration::get('FOXPOST_USER'), Configuration::get('FOXPOST_PASS'), Configuration::get('FOXPOST_API'));  

                    $FoxPostApi = $this->getAPI($this->API_LOG_LEVEL);

                    $status = $FoxPostApi->login(); //var_dump($status); var_dump($FoxPostApi);   exit; //

                    if ($status == true) {
                        Configuration::updateGlobalValue(self::$conf_prefix . 'STATE', 'WORKING');
                        $this->_confirmations[] = $this->{$this->translate_function}('Foxpost login successful!');
                    } else {
                        $this->_errors[] = $this->{$this->translate_function}('Foxpost login error!');
                    }
                }
            }
        }
        return $this->displayMessages();
    }

    /*    
    private function getCountriesForRA($id_lang, $limited = array(), $with_keys = false)
    {
        $countries = \Db::getInstance(_PS_USE_SQL_SLAVE_)->executes(
            'SELECT cl.`name`, c.iso_code
							FROM `' . _DB_PREFIX_ . 'country_lang` AS cl, `' . _DB_PREFIX_ . 'country` AS c
							WHERE cl.id_country=c.id_country AND cl.`id_lang` = ' . (int) $id_lang . ' ');

        return $countries;
    }        
*/







    public function getDefinitionConfigurePages()
    {
        return array(
            'cparam' => 'view',
            'pages' => array(
                'settings' => array('name' => $this->{$this->translate_function}('Base settings'), 'default' => true),
                'settings2' => array('name' => $this->{$this->translate_function}('Parcels and Orders'), 'icon' => ''),  //Csomag és rendelések állapotok
                'settings3' => array('name' => $this->{$this->translate_function}('Other settings'), 'icon' => ''),
                //'information' => array('name' => $this->{$this->translate_function}('Information'), 'icon' => 'icon-truck'),
            )
        );
    }

    public function displayMenu($def_pages)
    {
        $menu_items = array();
        foreach ($def_pages['pages'] as $page_key => $page_item) {
            $menu_items[$page_key] = array(
                'name' => $page_item['name'],
                'icon' => isset($page_item['icon']) ? $page_item['icon'] : '',
                'url' => $this->getModuleUrl() . '&' . $def_pages['cparam'] . '=' . $page_key,
                'active' => ((!in_array(Tools::getValue($def_pages['cparam']), array_keys($def_pages['pages'])) && isset($page_item['default']) && $page_item['default'] == true) || Tools::getValue($def_pages['cparam']) == $page_key) ? true : false
            );
        }

        $this->smarty->assign(array(
            'menu_items' => $menu_items,
            'module_version' => $this->version,
            'module_name' => $this->displayName,
            'changelog' => file_exists(dirname(__FILE__) . '/Readme.md'),
            'changelog_path' => $this->getModuleUrl() . '&' . $def_pages['cparam'] . '=changelog',
            '_path' => $this->_path
        ));

        return $this->display(__FILE__, 'views/templates/admin/menu.tpl');
    }

    public function getModuleUrl($params = false)
    {
        $url = $this->context->link->getAdminLink('AdminModules', true);
        //'index.php?controller=AdminModules&token='.Tools::getAdminTokenLite('AdminModules', $this->context).
        //'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $url .= '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        if (is_array($params) && count($params)) {
            foreach ($params as $k => $v) {
                $url .= '&' . $k . '=' . $v;
            }
        }

        return $url;
    }

    public static function getConfig($key, $default = null, $id_shop = null)
    {
        return Configuration::get(self::$conf_prefix . $key, null, null, $id_shop, $default);
    }






    public function installTab($tab_class, $tab_name, $parent = 'AdminModules', $active = false)
    {
        $tab = new Tab();
        $tab->active = (int)$active;
        $tab->class_name = $tab_class;
        $tab->name = array();

        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = $tab_name;
        }

        $tab->id_parent = (int)Tab::getIdFromClassName($parent);
        $tab->module = $this->name;

        return $tab->add();
    }

    public function uninstallTab($tab_class)
    {
        $id_tab = (int)Tab::getIdFromClassName($tab_class);

        if ($id_tab) {
            $tab = new Tab($id_tab);
            return $tab->delete();
        }

        return true;
    }

    public function displayMessages()
    {
        $messages = '';
        foreach ($this->_errors as $error) {
            $messages .= $this->displayError($error);
        }
        foreach ($this->_confirmations as $confirmation) {
            $messages .= $this->displayConfirmation($confirmation);
        }
        return $messages;
    }
    public function displayChangelog($file)
    {
        $this->smarty->assign(
            array(
                'changelog_content' => Tools::file_get_contents($file),
            )
        );

        return $this->display(__FILE__, 'views/templates/admin/changelog.tpl');
    }

    /**
     * Load available parcel sizes
     * 
     */
    public function getParcelSizes($forHTMLSelect = false)
    {

        $parcels = $HTMLSelect = array();
        foreach (FPHelper::getParcelSizes() as $size => $parcel) {    //mondjuk ez lehetne config-ból is....
            $parcel['name'] = $this->{$this->translate_function}($size);
            $parcels[$size] = $parcel;
            $HTMLSelect[] = array('id' => $size, 'name' => $parcel['name']);
        }
        if ($forHTMLSelect) return $HTMLSelect;
        return $parcels;
    }



    /**
     * Get an array of service codes to their names from the configuration,
     * or default if not set
     *
     * @return array
     */
    public static function getServicesNames()
    {
        $services_names = array(
            'APM'   => 'FOXPOST - Packeta Group automata', //'Foxpost parcel locker shipping',
            'HD'    => 'FOXPOST - Packeta Group házhozszállítás', //'Foxpost home delivery shipping'
        );

        return $services_names;
    }

    /**
     * Azt a leborult szivarvégit
     * 
     * @see    AdminCarrierWizardController::processRanges
     * 
     */
    public function installRanges($id_carrier)
    {
        //echo "installRanges 1 ";
        $carrier = new Carrier((int) $id_carrier);
        if (!Validate::isLoadedObject($carrier)) {
            return false;
        }
        //echo "installRanges 2 ";
        $range_type = Carrier::SHIPPING_METHOD_PRICE;
        $fees = array(1 => array(1250));
        $range_inf = array(
            0, 20000
        );
        $range_sup = array(
            20000, 1000000
        );
        //echo "installRanges 3 ";
        $carrier->deleteDeliveryPrice($carrier->getRangeTable());
        if ($range_type != Carrier::SHIPPING_METHOD_FREE) {
            //echo "installRanges 4 ";
            foreach ($range_inf as $key => $delimiter1) {
                if (!isset($range_sup[$key])) {
                    continue;
                }
                $range = $carrier->getRangeObject((int) $range_type);
                $range->id_carrier = (int) $carrier->id;
                $range->delimiter1 = (float) $delimiter1;
                $range->delimiter2 = (float) $range_sup[$key];
                $range->save();                  //call $carrier->addDeliveryPrice($price_list); b+++
                //echo "installRanges 5 ";
                if (!Validate::isLoadedObject($range)) {
                    return false;
                }
                $price_list = [];
                if (is_array($fees) && count($fees)) {
                    foreach ($fees as $id_zone => $fee) {
                        $price_list[] = [
                            'id_range_price'    => ($range_type == Carrier::SHIPPING_METHOD_PRICE ? (int) $range->id : null),
                            'id_range_weight'   => ($range_type == Carrier::SHIPPING_METHOD_WEIGHT ? (int) $range->id : null),
                            'id_carrier'        => (int) $carrier->id,
                            'id_zone'           => (int) $id_zone,
                            'price'             => isset($fee[$key]) ? (float) str_replace(',', '.', $fee[$key]) : 0,
                            'id_shop'           => null,
                            'id_shop_group'     => null,
                        ];
                    }
                }
                //echo "installRanges 6 ";           
                //print_r($price_list);//exit;
                if (count($price_list) && !$carrier->addDeliveryPrice($price_list, true)) {
                    return false;
                }
            }
        }

        return true;
    }


    /**
     * Create DB table
     *  id_order: PS rendelés azon.
     *  shipping_method: HD|APM
     *  operator_id: APM esetén pl "hu631"
     *  barcode: Foxpost csomag azon.
     *  error: Hiba szövegesen
     *  status: szállítás állapota: 0-4 
     *  exported: exportálva CSVbe
     *  printed: nyomtatva volt-e a cimke
     *  deleted: előfordulhat, hogy más szállítót kell a rendelésbe
     *           ilyenkor töröljük
     * @return boolean
     */
    private function createDbTables()
    {
        $return = true;

        $return &= (bool)Db::getInstance()->Execute(
            'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'foxpost_package` (
                `id_foxpost_package` int(11) NOT NULL AUTO_INCREMENT,
                `id_order` int(11) NOT NULL, 
                `id_carrier` int(11) NOT NULL, 
                `shipping_method` varchar(10) NOT NULL,
                `parcel_size` varchar(3) NOT NULL,                   
                `operator_id` varchar(10) DEFAULT NULL,       
                `barcode` varchar(255) DEFAULT NULL,    
                `error` varchar(255) DEFAULT NULL,     
                `parcel_status` varchar(255) DEFAULT NULL,                     
                `parcel_status_name` varchar(255) DEFAULT NULL,                    
                `active` int(11) NOT NULL DEFAULT \'1\', 
                `exported` int(11) NOT NULL DEFAULT \'0\',
                `printed` int(11) NOT NULL DEFAULT \'0\',                 
                `status` int(11) NOT NULL DEFAULT \'0\',  
                `date_add` datetime NOT NULL,
                `date_upd` datetime NOT NULL,
                    PRIMARY KEY (`id_foxpost_package`)
                ) ENGINE=' . _MYSQL_ENGINE_ . '  DEFAULT CHARSET=utf8'
        );
        $return &= (bool)Db::getInstance()->Execute(
            'ALTER TABLE `' . _DB_PREFIX_ . 'foxpost_package` ADD UNIQUE(`id_order`);'
        );
        $this->log_d('DB tables created');

        return (bool)$return;
    }


    /**
     * NOT delete tables, never!
     *
     * @return true
     */
    private function dropDbTables()
    {
        if (false) {
            $shipment_table = \Db::getInstance()->execute(
                "DROP TABLE IF EXISTS " . _DB_PREFIX_ . "foxpost_package"
            );
            return $shipment_table;
        }

        return true;
    }

    /**
     * uninstall carriers
     *
     * @return void
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     * @throws ReflectionException
     */
    private function uninstallCarriers()
    {

        foreach (array_keys(self::getServicesNames()) as $service_code) {
            $ref = Configuration::get(self::$conf_prefix . $service_code);
            if ($ref === false) continue;    //Ha törölve lett kézzel

            //$carrier = Carrier::getCarrierByReference($ref); 

            $carriers = \Db::getInstance()->executeS('SELECT `id_carrier` FROM `' . _DB_PREFIX_ . 'carrier`
			WHERE id_reference = ' . (int) $ref . ' ORDER BY id_carrier DESC');


            foreach ($carriers as $carrier_id) {

                $carrier = new Carrier($carrier_id['id_carrier']);

                if (Validate::isLoadedObject($carrier)) {
                    $carrier->delete();

                    $carrier->deleted = 1;
                    $carrier->active = 0;
                    $carrier->update();
                    $this->log_d('carrier deleted #' . $carrier->id);
                }
            }

            @unlink(_PS_SHIP_IMG_DIR_ . (int)$ref . '.jpg');
        }
        //exit("**");

        Configuration::updateValue(self::$conf_prefix . 'CARRIER_IDS', json_encode(array()));
        return true;
    }
    /**
     * install carriers
     *
     * @return void
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     * @throws ReflectionException
     */
    private function installCarriers()
    {
        $carrier_id_service_code = array();

        foreach (self::getServicesNames() as $service_code => $name) {
            $added_carrier = $this->addCarrier($this->{$this->translate_function}($name), self::$conf_prefix . $service_code);

            if ($added_carrier) {
                $id_reference = $added_carrier->id_reference;
                $this->log_d("installCarriers: $name #$id_reference");

                if (!$id_reference) {
                    $id_reference = $added_carrier->id;
                }
                $carrier_id_service_code[$id_reference] = $service_code;
            }
        }
        //print_r($carrier_id_service_code);exit;

        Configuration::updateValue(self::$conf_prefix . 'CARRIER_IDS', json_encode($carrier_id_service_code));

        return true;
    }



    private function addCODProd(float $feevalue, $reference = 'fxcodfee')
    {
        $default_lang = Configuration::get('PS_LANG_DEFAULT');

        foreach (Language::getIDs(false) as $id_lang) {
            $product_name[$id_lang] = 'Utánvét kezelési költsége';
        }

        //add product
        $product = new Product();
        $product->reference = $reference;
        $product->name = $product_name;
        $product->description = htmlspecialchars('Utánvét kezelési költsége');
        $product->id_category_default = 0;
        $product->redirect_type = '404';
        $product->price = number_format((float)$feevalue, 0, '.', '');
        $product->minimal_quantity = 1;
        $product->show_price = 1;
        $product->on_sale = 0;
        $product->online_only = 0;
        $product->meta_description = '';
        $product->indexed = 0;
        $product->visibility = 'none';
        $product->is_virtual = 1;
        $product->product_type = 'virtual';
        //$product->link_rewrite = createMultiLangField(Tools::str2url($name)); // Contribution credits: mfdenis
        $product->add();                        // Submit new product

        StockAvailable::setQuantity($product->id, null, 10000); // id_product, id_product_attribute, quantity
        $product->addToCategories(0);     // After product is submitted insert all categories



        //add product image
        $shops = Shop::getShops(true, null, true);
        $image = new Image();
        $image->id_product = $product->id;
        $image->position = Image::getHighestPosition($product->id) + 1;
        $image->cover = true;
        $image->legend = $product_name;
        if (($image->validateFields(false, true)) === true && ($image->validateFieldsLang(false, true)) === true && $image->add()) {
            $image->associateTo($shops);

            //$to = $image->getPathForCreation();
            $logo = dirname(__FILE__) . '/views/img/logo.png';  //echo $from;

            $tmpfile = tempnam(_PS_TMP_IMG_DIR_, $this->name);   //echo $tmpfile;

            if (@copy($logo, $tmpfile)) {
                ImageManager::resize($tmpfile, $image->getPathForCreation() . '.jpg');
                // ps_image_type
                @copy($image->getPathForCreation() . '.jpg', $image->getPathForCreation() . '-cart_default.jpg');
                @copy($image->getPathForCreation() . '.jpg', $image->getPathForCreation() . '-home_default.jpg');
                @copy($image->getPathForCreation() . '.jpg', $image->getPathForCreation() . '-large_default.jpg');
                @copy($image->getPathForCreation() . '.jpg', $image->getPathForCreation() . '-medium_default.jpg');
                @copy($image->getPathForCreation() . '.jpg', $image->getPathForCreation() . '-small_default.jpg');
            }
            unlink($tmpfile);
        }
        return $product->id;
    }


    /**
     * Add a carrier
     *
     * @param string $name Carrier name
     * @param string $key Carrier ID
     *
     * @return Carrier|false
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function addCarrier($name, $key)
    {
        $this->log_d('addCarrier');
        $key = Tools::strtoupper($key);
        $id_reference = \Db::getInstance()->getValue(
            $s =
                "SELECT value FROM " . _DB_PREFIX_ . "configuration WHERE name LIKE '" . pSQL($key) .
                "' ORDER BY id_configuration DESC"
        );


        if ($id_reference !== false) {
            $carrier = Carrier::getCarrierByReference($id_reference);
            if (Validate::isLoadedObject($carrier)) {
                return $carrier; // Already added to DB
            }
        }


        $carrier = new Carrier();
        $carrier->name = $name;
        $carrier->delay = array();
        $carrier->is_module = true; //false;
        $carrier->shipping_method = Carrier::SHIPPING_METHOD_PRICE; //2
        $carrier->active = 0;
        $carrier->range_behavior = 0;
        $carrier->need_range = 1;  //Ez nagyon fura de különben nem megy a is_module és amiatt meg a displayCarrierExtraContent hook
        $carrier->url = str_replace('%s', '@', FoxPostApi::TRACEURL);
        $carrier->max_weight = 25.0;  //5,15,25
        $carrier->external_module_name = 'foxpost';


        foreach (Language::getLanguages() as $lang) {
            $id_lang = (int)$lang['id_lang'];
            $days = ($lang['iso_code'] == 'hu') ? $this->{$this->translate_function}('day') : 'day';
            $carrier->delay[$id_lang] = "5 $days";
        }

        if ($carrier->add()) {
            $this->log_d('carrier added');
            $logo =  _PS_SHIP_IMG_DIR_ . (int)$carrier->id . '.jpg'; //Nem kell DIRECTORY_SEPARATOR

            if (file_exists($logo)) @unlink($logo);

            @copy(dirname(__FILE__) . '/views/img/logo.png', $logo);

            $id_reference = (int) $carrier->id_reference ?: (int) $carrier->id;
            \Db::getInstance()->query(
                "INSERT " . _DB_PREFIX_ . "configuration SET name='" . pSQL($key) . "', value=$id_reference"
            );
            $this->addGroups($carrier);

            $carrier->setTaxRulesGroup(0); //No-TAX

            //Nem lehet rendesen megoldani a shop tulajnak kell megoldania    
            //$carrier->addZone( Zone::getIdByName('Europe') ); 
            //$this->installRanges($id_reference);

            return $carrier;
        }

        return false;
    }


    /**
     * @param Carrier $carrier
     */
    protected function addGroups(Carrier $carrier)
    {
        $groups_ids = array();
        $groups = Group::getGroups(Context::getContext()->language->id);

        foreach ($groups as $group) {
            $groups_ids[] = $group['id_group'];
        }

        $carrier->setGroups($groups_ids);
    }

    /**
     * Logger::EMERGENCY,ALERT,CRITICAL: 4;
     * Logger::ERROR: 3;
     * Logger::WARNING: 2;
     * Logger::NOTICE,INFO,DEBUG: 1;
     * default: 0;
     * 
     * 
     */
    public function log_a(String $msg)
    {
        $this->logger->alert($this->name . ': ' . $msg, ['object_type' => 'Module', 'object_id' => LegacyModule::getModuleIdByName($this->name)]);
    }

    public function log_e(String $msg)
    {
        $this->logger->error($this->name . ': ' . $msg, ['object_type' => 'Module', 'object_id' => LegacyModule::getModuleIdByName($this->name)]);
    }

    public function log_w(String $msg)
    {
        $this->logger->warning($this->name . ': ' . $msg, ['object_type' => 'Module', 'object_id' => LegacyModule::getModuleIdByName($this->name)]);
    }

    public function log_d(String $msg)
    {
        if (_PS_MODE_DEV_ == true)
            $this->logger->debug($this->name . ': ' . $msg, ['object_type' => 'Module', 'object_id' => LegacyModule::getModuleIdByName($this->name)]);
    }

    /**
     * Better and sorter getValue
     * 
     * @see Tools::getValue
     * 
     */
    private function gV(String $key)
    {
        return pSQL(trim(Tools::getValue($key)));
    }

    /**
     * Configure FoxPostApi to this enviromment 
     * 
     * @param $loglevel API log level
     * @return object API object
     */
    public function getAPI(int $loglevel = 2)
    {

        if (is_null($this->FoxPostApi) || (!$this->FoxPostApi instanceof FoxPostApi)) {
            $FoxPostApi = new FoxPostApi($loglevel);
            //$logdir = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'logs' . DIRECTORY_SEPARATOR . 'API'. DIRECTORY_SEPARATOR ;
            $workdir = _PS_MODULE_DIR_ . $this->name . DIRECTORY_SEPARATOR . 'logs' . DIRECTORY_SEPARATOR . 'API' . DIRECTORY_SEPARATOR;
            /*            
            if (!file_exists($logdir)){
                umask(0777);
                $filesystem = new Filesystem();
                $filesystem->mkdir($logdir, 0755);
                $filesystem->chmod($logdir, 0755, 0000, true);
            } //mkdir($logdir, 0755, true);
*/
            $FoxPostApi->setTmpDir($workdir);
            $FoxPostApi->setCred(Configuration::get('FOXPOST_USER'), Configuration::get('FOXPOST_PASS'), Configuration::get('FOXPOST_API'));
            $FoxPostApi->setUserAgent(array('PrestaShop' => _PS_VERSION_));
            $this->FoxPostApi = $FoxPostApi;
        }
        return $this->FoxPostApi;
    }

    /**
     * @return array
     */
    public function getExtraTranslations()
    {
        return array(
            $this->{$this->translate_function}('FX_PARCEL_STATUS_READY'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_CREATE'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_OPERIN'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_OPEROUT'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_SORTIN'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_HDSENT'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_C2BIN'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_C2CIN'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_COLLECTED'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_HINT_READY'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_HINT_CREATE'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_HINT_OPERIN'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_HINT_OPEROUT'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_HINT_SORTIN'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_HINT_HDSENT'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_HINT_C2BIN'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_HINT_C2CIN'),
            $this->{$this->translate_function}('FX_PARCEL_STATUS_HINT_COLLECTED'),
            $this->{$this->translate_function}('#%s order'),
            $this->{$this->translate_function}('Label only print one time!'),
            $this->{$this->translate_function}('Nothing to do! Sync available only: %s min.'),
            $this->{$this->translate_function}('The order #%s carrier cannot be updated, tracking_number not updated!'),
            $this->{$this->translate_function}('Only once send parcel to Foxpost!'),

        );
    }
}
