{**
* FoxPost
*
* @author Foxpost <kovago.balazs@foxpost.hu>
* @copyright 2022 GT
* @license   See joined file licence.txt
* @category  Module
* @support   Support <support@foxpost.hu>
* @version   0.0.1
* @link      https://www.foxpost.hu
*}

<script type="text/javascript">
var foxpost_baselink = '{$link}';
var foxpost_parcel_status = {$parcel.status|default:'0'};
var foxpost_barcode = '{$parcel.barcode|default:''}';
$(document).ready(function(){   
    
    if(foxpost_barcode==''){
        $('#fx_printlabel').attr('aria-disabled', 'true'); 
        $('#fx_printlabel').addClass('disabled');      
    }
        
    
    $('#fx_barcode').change(function(){
        if ($('#fx_barcode').val()!=''){
            $('#fx_printlabel').attr('aria-disabled', 'false'); 
            $('#fx_printlabel').removeClass('disabled');   
        }
    });
    
    
    $('#fx_genlabel').click(function(evt){
        evt.preventDefault();
        package_size = $( document.getElementsByName("fx_package_size")[0] ).val(); 
        $.ajax({
            dataType: 'json',
            type: "POST",
            url: foxpost_baselink+'&ajax=1&action=createLabel',        
            headers: { "cache-control": "no-cache" },
            cache: false,
            async: true,
            data: "parcel_size="+package_size,
            beforeSend: function () {
                $('#loading-indicator').show();
                //$this.attr('disabled', true);
            },
            complete: function() {        
                $('#loading-indicator').hide();
                //$this.attr('disabled', false);
            },   
            success: function(data) {
                if (data.success==true) {
                    $('#fx_barcode').val(data.trackingnumber);
                    $('#fx_barcode').html(data.trackingnumber);
                    $('#fx_barcode').trigger( "change" );
                } else {
                    alert(data.message);
                }
            }
        });

      return false;
    });  

    
         
}); 
</script>


<div class="row foxpost_order_block">
	<div class="col-lg-12">
		<div class="panel foxpost_order_panel card card-body">
			<div class="panel-heading card-header foxpost-panel-heading">
				<i class="icon-truck"></i> {l s='FOXPOST - Packeta Group delivery' mod='foxpost'} <span class="float-right">{$module_name|escape:'htmlall':'UTF-8'} v{$module_version|escape:'htmlall':'UTF-8'}</span>
			</div>

			{if isset($foxpost_errors) && $foxpost_errors|@count}
				<div class="alert alert-danger"><ul>
				{foreach from=$foxpost_errors item=foxpost_error}
					<li>{$foxpost_error|escape:'htmlall':'UTF-8'}</li>
				{/foreach}
				</ul></div>
			{/if}

			{if isset($foxpost_confirmations) && $foxpost_confirmations|@count}
				<div class="alert alert-success"><ul>
				{foreach from=$foxpost_confirmations item=foxpost_confirmation}
					<li>{$foxpost_confirmation|escape:'htmlall':'UTF-8'}</li>
				{/foreach}
			</ul></div>
			{/if}

			{if isset($foxpost_warnings) && $foxpost_warnings|@count}
				<div class="alert alert-warning"><ul>
				{foreach from=$foxpost_warnings item=foxpost_warning}
					<li>{$foxpost_warning|escape:'htmlall':'UTF-8'}</li>
				{/foreach}
			</ul></div>
			{/if}



			<form method="post" action="" class="form-inline">

				<div class="table-responsive">
					<table class="table std foxpost_table" cellspacing="0" cellpadding="0">
						<thead>
							<tr>
								<th>{l s='Service' mod='foxpost'}</th>
								<th>{l s='Barcode' mod='foxpost'}</th>
								<th>{l s='Parcel' mod='foxpost'}</th>
								<th>{l s='Actions' mod='foxpost'}</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>{$parcel.shipping_method|escape:'htmlall':'UTF-8'}</td>
                                
								<td>     
									<div class="row">
										<!--input class="form-control" type="text" id="fx_barcode" name="fx_barcode" value="{$parcel.barcode|escape:'htmlall':'UTF-8'}" readonly="readonly"/-->
                                        <span id="fx_barcode" name="fx_barcode">{$parcel.barcode|escape:'htmlall':'UTF-8'|default:'-'}</span>
                                    	<label for="fx_barcode" class="required"><img src="/img/loader.gif" id="loading-indicator" style="height: initial;vertical-align: middle;display: table-cell; display:none;" /></label>
                                        <span class="help-block">{l s='' mod='foxpost'}</span>
                                        <!--a class="btn btn-default" href="{$tracking_url|escape:'html':'UTF-8'}" target="_blank"><i class="icon-search"></i> {l s='Tracking' mod='foxpost'}</a-->
									</div>
								</td>
                                
								<td>
                                    <div id="foxpost_params" class="row">
                                        <label for="fx_package_size" class="control-label col-lg-3 required">{l s='Size' mod='foxpost'}</label>
                                        {html_options name=fx_package_size options=$parcel_sizes selected=$parcel.parcel_size}
                                        <span class="help-block"></span>
                                    </div>                             
								</td>                  
                                
								<td>
									<input type="button" class="btn btn-primary" id="fx_genlabel" name="fx_genlabel" value="{l s='Generate label' mod='foxpost'}" />
                                    <a href="{$link}&ajax=1&action=printLabel" target="" tabindex="-1" class="btn btn-primary" id="fx_printlabel" name="fx_printlabel" value="">{l s='Print label' mod='foxpost'}</a>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
            </form>

      
            
		</div>
	</div>

</div>