<?php
require_once _PS_ROOT_DIR_ . '/modules/foxpost/classes/FPPackage.php';

use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * FoxPost official plugin
 *
 * @author Foxpost <kovago.balazs@foxpost.hu>
 * @copyright 2022 FoxPost Zrt.
 * @license   See joined file licence.txt
 * @category  Module
 * @support   Support <b2chelpdesk@foxpost.hu>
 * @version   0.0.1
 * @link      https://www.foxpost.hu
 */

if (!defined('_PS_VERSION_')) exit;


class AdminFoxPostController extends ModuleAdminController
{

    private $API_LOG_LEVEL = 2;

    public function __construct()
    {
        parent::__construct();
        // Base
        $this->bootstrap = false; // use Bootstrap CSS
        $this->table = ''; // SQL table name, will be prefixed with _DB_PREFIX_
        $this->identifier = ''; // SQL column to be used as primary key
        $this->className = ''; // PHP class name
        $this->allow_export = false; // allow export in CSV, XLS..
        $this->visible = false;
        $this->module = 'foxpost';

        $this->API_LOG_LEVEL = Configuration::get('FOXPOST_API_LOG_LEVEL');
        if (_PS_MODE_DEV_ == true) $this->API_LOG_LEVEL = 6;
    }


    /**
     * Print label
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function ProcessPrintLabel()  //ajax
    {
        //echo 'ProcessPrintLabel';
        $id_order = (int)Tools::getValue('id_order');
        $order = new Order($id_order);

        if (!Validate::isLoadedObject($order)) {
            exit('Order not exists');
        }

        $FoxPostApi = $this->getAPI($this->API_LOG_LEVEL); //print_r($FoxPostApi);
        $FoxPostApi->setTmpDir(dirname(__FILE__) . DIRECTORY_SEPARATOR . '../../logs' . DIRECTORY_SEPARATOR . 'API' . DIRECTORY_SEPARATOR);

        $parcel = FPPackage::getShipmentInfoByOrderId($id_order);

        $pdf_name = $FoxPostApi->parcelLabel(array($parcel['barcode']), FoxPost::getConfig('FOXPOST_LABEL_SIZE', 'A7')); //  var_dump($parcel);   var_dump($FoxPostApi);        

        if ($FoxPostApi->error == true) {
            exit("API error: " . $FoxPostApi->getLog());
        }

        $file = _PS_MODULE_DIR_ . "foxpost/logs/API/labels/{$pdf_name}";
        $filesize = filesize($file);
        if ($filesize > 1) {
            FPPackage::setS2($parcel['barcode']);

            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header("Content-Type: application/pdf");
            header("Content-Disposition: inline; filename={$pdf_name}");
            header('Content-Length: ' . $filesize);

            //header('Content-Description: File Transfer');
            //header('Content-Disposition: attachment; filename="'.basename($file).'"');

            readfile($file);
            exit;
        }
        exit("API/PDF error: " . $FoxPostApi->getLog());
    }
    /**
     * Order shipment by ajax
     *
     * @return mixed|string
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function ajaxProcessDlLog()
    {
        $this->ajax = true;

        $filename = (int)Tools::getValue('file');

        $file = _PS_MODULE_DIR_ . "foxpost/logs/API/logs/{$filename}.log";

        if (file_exists($file)) {
            $filesize = filesize($file);
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header("Content-Type: text/plain");
            header("Content-Disposition: attachment; filename={$filename}.log");
            header('Content-Length: ' . $filesize);
            header('Content-Description: File Transfer');

            readfile($file);
        }
        exit;
    }
    /**
     * Order shipment by ajax
     *
     * @return mixed|string
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function ajaxProcessCreateLabel()
    {
        $this->ajax = true;
        $id_order       = (int)Tools::getValue('id_order');
        $parcel_size    = Tools::getValue('parcel_size');
        $order          = new Order($id_order);

        if (!empty($parcel_size)) {
            $package = FPPackage::getFPPackageByOrderId($id_order);
            $package->parcel_size = pSQL($parcel_size);
            $package->update();
        }


        //FoxPost
        $message = "";
        $label = FPHelper::getLabelFromFoxPostNew(array($order), $message, 6);

        if ($label == false) {
            $this->ajaxDie(json_encode(array('success' => false, 'message' => $message, 'trackingnumber' => '')));
        }
        //print_r($package);echo $message;exit;
        $tracking_number = $label[$id_order];


        //PrestaShop        
        $ps = FPHelper::setLabelToPrestaShop($order, $tracking_number);
        if ($ps == false)
            $this->ajaxDie(json_encode(array('success' => false, 'message' => $this->l('The order carrier cannot be updated.'),  'trackingnumber' => '')));
        else
            $this->ajaxDie(json_encode(array('success' => true,  'message' => $this->l('Label created.'),                        'trackingnumber' => $tracking_number)));
    }


    /**
     * Configure FoxPostApi to this enviromment 
     * 
     * @param $loglevel API log level
     * @return object API object
     */
    private function getAPI(int $loglevel = 2)
    {

        //if ( is_null($this->FoxPostApi) || ( ! $this->FoxPostApi instanceof FoxPostApi ) ){
        $FoxPostApi = new FoxPostApi($this->API_LOG_LEVEL);
        $logdir = dirname(__FILE__) . DIRECTORY_SEPARATOR . '../../logs' . DIRECTORY_SEPARATOR . 'API' . DIRECTORY_SEPARATOR;
        //if (!file_exists($logdir)) mkdir($logdir, true);
        $FoxPostApi->setTmpDir($logdir);
        $FoxPostApi->setCred(Configuration::get('FOXPOST_USER'), Configuration::get('FOXPOST_PASS'), Configuration::get('FOXPOST_API'));
        $FoxPostApi->setUserAgent(array('PrestaShop' => _PS_VERSION_));
        $this->FoxPostApi = $FoxPostApi;
        //} 
        //return $this->FoxPostApi; 
        return $FoxPostApi;
    }
}
