<?php
//require_once _PS_ROOT_DIR_.'/modules/foxpost/classes/FPHelper.php';
require_once(dirname(__FILE__) . '/../../src/FoxPostApi.php');
require_once(dirname(__FILE__) . '/../../classes/FPHelper.php');
require_once(dirname(__FILE__) . '/../../classes/FPPackage.php');

/**
 * FoxPost official plugin
 *
 * @author Foxpost <kovago.balazs@foxpost.hu>
 * @copyright 2022 FoxPost Zrt.
 * @license   See joined file licence.txt
 * @category  Module
 * @support   Support <b2chelpdesk@foxpost.hu>
 * @version   0.0.1
 * @link      https://www.foxpost.hu
 */

if (!defined('_PS_VERSION_')) exit;


class AdminFoxPostOrderController extends ModuleAdminController
{

    private $API_LOG_LEVEL = 2;
    protected $statuses_array = array();
    public function __construct()
    {
        parent::__construct();
        
        $this->bootstrap = true;
        $this->table = 'order';
        $this->className = 'Order';
        $this->identifier = 'id_order'; // Set identifier for HelperList to generate view links correctly
        $this->lang = false;
        $this->explicitSelect = true;
        $this->allow_export = true;
        $this->deleted = false;
        // Don't override $this->module - it's already set by parent::__construct() as Module object
        // $this->module = 'foxpost'; // Removed: this was overriding the Module object with a string

        $this->addRowAction('view');

        if (_PS_MODE_DEV_ == true) $this->API_LOG_LEVEL = 6;

        $this->_select = '
        a.id_order,
        a.id_currency,
        CONCAT(LEFT(c.`firstname`, 1), \'. \', c.`lastname`) AS `customer`,
        osl.`name` AS `osname`,
        os.`color`,
        IF(a.valid, 1, 0) badge_success';

        $this->_join = '
        LEFT JOIN  `' . _DB_PREFIX_ . 'customer` c ON (c.`id_customer` = a.`id_customer`)
        INNER JOIN  `' . _DB_PREFIX_ . 'foxpost_package` f ON (f.`id_order` = a.`id_order`)


        LEFT JOIN `' . _DB_PREFIX_ . 'order_state` os ON (os.`id_order_state` = a.`current_state`)
        LEFT JOIN `' . _DB_PREFIX_ . 'order_state_lang` osl ON (os.`id_order_state` = osl.`id_order_state` AND osl.`' .
            'id_lang` = ' . (int)$this->context->language->id . ')';

        $this->_orderBy = 'id_order';
        $this->_orderWay = 'DESC';
        $this->_use_found_rows = true;


        $statuses = OrderState::getOrderStates((int)$this->context->language->id);
        foreach ($statuses as $status) {
            // Ensure $status is an array and has the required keys
            if (is_array($status) && isset($status['id_order_state']) && isset($status['name'])) {
                // Store as simple key-value pairs for HelperList compatibility
                // HelperList expects: [id => 'name', id => 'name', ...]
                $this->statuses_array[$status['id_order_state']] = $status['name'];
            }
        }


        $this->fields_list = array(
            'id_order' => array(
                'title' => Context::getContext()->getTranslator()->trans('ID', array(), 'Admin.Global'),
                'align' => 'text-center',
                'class' => 'fixed-width-xs',
            ),
            'reference' => array(
                'title' => Context::getContext()->getTranslator()->trans('Reference', array(), 'Admin.Global'),
            ),
            'customer' => array(
                'title' => Context::getContext()->getTranslator()->trans('Customer', array(), 'Admin.Global'),
                'havingFilter' => true,
            ),

            'payment' => array(
                'title' => Context::getContext()->getTranslator()->trans('Payment', array(), 'Admin.Global'),
                'search' => false,
                'orderby' => false,
            ),
            'total_paid_tax_incl' => array(
                'title' => Context::getContext()->getTranslator()->trans('Total', array(), 'Admin.Global'),
                'align' => 'text-right',
                'type' => 'price',
                'currency' => true,
                //'callback' => 'setOrderCurrency',
                'search' => false,
                'badge_success' => true,
            ),
            'osname' => array(
                'title' => Context::getContext()->getTranslator()->trans('Status'),
                'type' => 'select',
                'color' => 'color',
                'list' => $this->statuses_array,
                'filter_key' => 'os!id_order_state',
                'filter_type' => 'int',
                'order_key' => 'osname',
            ),
            'barcode' => array(
                'title' => Context::getContext()->getTranslator()->trans('Barcode'),
                'search' => false,
                'orderby' => true,
                'order_key' => 'barcode',
            ),
            'printed' => array(
                'title' => Context::getContext()->getTranslator()->trans('Printed'),
                'type' => 'select',
                'list' => array(0 => 'No', 1 => 'Yes'),
                'filter_key' => 'f!printed',
                'filter_type' => 'int',
                'order_key' => 'printed',
                'callback' => 'printOptinIcon',
            ),
            'exported' => array(
                'title' => Context::getContext()->getTranslator()->trans('Exported'),
                'type' => 'select',
                'list' => array(0 => 'No', 1 => 'Yes'),
                'filter_key' => 'f!exported',
                'filter_type' => 'int',
                'order_key' => 'exported',
                'callback' => 'printOptinIcon',
            ),
            'error' => array(
                'title' => Context::getContext()->getTranslator()->trans('Error'),
                //'type' => 'text',
                'search' => false,
                'orderby' => false,
            ),
            'parcel_status_name' => array(
                'title' => Context::getContext()->getTranslator()->trans('Delivery status'),
                //'type' => 'text',
                'search' => false,
                'orderby' => false,
            ),

            //parcel_size
        );












        $this->shopLinkType = 'shop';
        $this->shopShareDatas = Shop::SHARE_ORDER;

        $this->bulk_actions = array(
            'LabelAndPrint' => array(
                'text' => Context::getContext()->getTranslator()->trans('Label&Print'),
                'icon' => 'icon-print'
            ),
            'Export' => array(
                'text' => Context::getContext()->getTranslator()->trans('Export'),
                'icon' => 'icon-export'
            ),
            'updateOrderStatus' => array(
                'text' => Context::getContext()->getTranslator()->trans('Refresh', array(), 'Install'), //$this->{$this->translate_function('Refresh'),  
                'icon' => 'icon-refresh'
            ),
        );
    }

    public function printOptinIcon($value, $customer)
    {
        return $value ? '<i class="icon-check"></i>' : '<i class="icon-remove"></i>';
    }


    public function postProcess()
    {
        $ok = $error = [];

        if (Tools::isSubmit('updateParcelsStates')) {
            $helpMe = new FPHelper();
            $result = $helpMe->updateParcelState('admin');

            switch ($result) {
                case 1:
                    $this->informations[] = Context::getContext()->getTranslator()->trans('Statuses updated.');
                    break;
                case 2:
                    $this->errors[] = Context::getContext()->getTranslator()->trans('Something wrong: ') . $helpMe->log();
                    break;
                case 0:
                default:
                    $this->warnings[] = sprintf(Context::getContext()->getTranslator()->trans('Nothing to do! Sync available only: %s min.'), FoxPost::SYNC_MIN_MINUTE);
            }
        }


        //RELABEL
        if (Tools::isSubmit('submitBulkLabelAndPrintorder') && Tools::getIsset('orderBox')) {
            //$this->errors[] = Tools::displayError('Please select manifest date. Manifest date is empty.');

            //FoxPost
            $messages = $orders = array();
            foreach ((array)Tools::getValue('orderBox') as $orderId) {
                $orders[] = new Order((int) $orderId);
            }
            $result = FPHelper::getLabelFromFoxPost($orders, $messages, 6); //print_r($result);exit($messages); 

            //PrestaShop  
            if (is_array($result)) {
                $orders = array();
                foreach ($result as $orderId => $tracking_number) {
                    $order = new Order((int) $orderId);
                    $orders[] = $order;
                    $ps = FPHelper::setLabelToPrestaShop($order, $tracking_number);
                    if ($ps == false) {
                        //$this->module->log_w("The order #$orderId carrier cannot be updated, tracking_number not updated!");
                        $this->warnings[] = sprintf(Context::getContext()->getTranslator()->trans('The order #%s carrier cannot be updated, tracking_number not updated!'), $orderId);
                    }
                }
                FPHelper::printLabel($orders);
                $this->confirmations[] = count(Tools::getValue('orderBox')) . Context::getContext()->getTranslator()->trans(' label(s) created!');
                //$this->addFlash('confirmations', Context::getContext()->getTranslator()->trans(count(Tools::getValue('orderBox'))." label(s) created! ") );
            } else {
                //$this->module->log_e("Label(s) not created: $messages!");
                //$this->warning[] =Context::getContext()->getTranslator()->trans("Label(s) not created! ").$messages;
                $this->errors[] = Context::getContext()->getTranslator()->trans('Label(s) not created!') . '<br/>' . FPHelper::getStringFromArray($messages, Context::getContext()->getTranslator()->trans('#%d order'));
                //$this->addFlash('error',Context::getContext()->getTranslator()->trans("Label(s) not created!s ").$messages );

                //print_r($messages);exit('ERROR'); 
            }
        }

        //REPARCEL
        if (Tools::isSubmit('submitBulkExportorder') && Tools::getIsset('orderBox')) {

            $orders = array();
            foreach ((array)Tools::getValue('orderBox') as $orderId) {
                $orders[] = new Order((int) $orderId);
            }
            FPHelper::exportOrder($orders);
        }

        /*    
        $this->warnings[] = 'warnings';
        $this->informations[]  = 'informations';
        */

        return;
    }


    /**
     * Set back system order view template instead auto load from module
     * @return string
     */
    public function renderView()
    {
        $this->tpl_folder = 'orders/';
        $view = parent::renderView();
        return $view;
    }

    /**
     * Replace system route with module route
     * @return false|string|string[]|null
     * @throws PrestaShopException
     */
    public function renderList()
    {
        $list = parent::renderList();
        return $list; // . $this->spring->hookDisplayAdminListAfter(['doAnyway' => true]);
    }
}
