<?php

/**
 * FoxPost official plugin
 *
 * 
 * @author Foxpost <kovago.balazs@foxpost.hu>
 * @copyright 2022 FoxPost Zrt.
 * @license   See joined file licence.txt
 * @category  Module
 * @support   Support <b2chelpdesk@foxpost.hu>
 * @version   0.0.1
 * @link      https://www.foxpost.hu
 * @see       https://prestashop.devwing.hu/module/foxpost/cron?ajax=1
 */

if (!defined('_PS_VERSION_')) exit;

require_once(_PS_MODULE_DIR_ . 'foxpost/src/FoxPostApi.php');
require_once(_PS_MODULE_DIR_ . 'foxpost/classes/FPHelper.php');
require_once(_PS_MODULE_DIR_ . 'foxpost/classes/FPPackage.php');

class FoxPostCronModuleFrontController extends ModuleFrontController
{
    /** @var bool If set to true, will be redirected to authentication page */
    public $auth = false;

    /** @var bool */
    public $ajax = 1;

    public function __construct()
    {
        parent::__construct();

        if (php_sapi_name() == 'cli') {
            $helpMeHelper = new FPHelper();
            $helpMeHelper->updateParcelState('cron');
            echo $helpMeHelper->log();
            echo "\n";
        } else {   //apache2handler...stb...
            error_reporting(0);
            $helpMeHelper = new FPHelper();
            $helpMeHelper->updateParcelState('web');
        }
        exit;
    }
}
