<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
require_once plugin_dir_path( __FILE__ ) . 'class-foxpost-wc-shipping-logger.php' ; 
             
/**
 *
 * @link       https://foxpost.hu
 * @since      1.0.0
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/includes
 */
if (!defined('ABSPATH')) {
    die;
}
         
/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/includes            
 * @author     Foxpost.hu <b2chelpdesk@foxpost.hu>
 */               
class Foxpost_Wc_Shipping {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Foxpost_Wc_Shipping_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $foxpost_wc_shipping    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;
 
    /**
     *
     * @since 1.0.0
     * @var string
     */
    const NAME = 'foxpost-wc-shipping';
    
    /**
     * Config file
     *
     * @since 1.0.1
     * @var string
     */
    private $config;
    
    const SYNC_MIN_MINUTE = 5;  
        
    /**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */     
	public function __construct() {                         
        $this->config = self::loadConfig();

		if ( defined( 'FOXPOST_WC_SHIPPING_VERSION' ) ) {
			$this->version = FOXPOST_WC_SHIPPING_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'foxpost-wc-shipping';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();        
        $this->define_hpos_functions();   
    }
    
	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Foxpost_Wc_Shipping_Loader.   Orchestrates the hooks of the plugin.
	 * - Foxpost_Wc_Shipping_i18n.     Defines internationalization functionality.
	 * - Foxpost_Wc_Shipping_Admin.    Defines all hooks for the admin area.
	 * - Foxpost_Wc_Shipping_Public.   Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-foxpost-wc-shipping-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-foxpost-wc-shipping-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-foxpost-wc-shipping-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-foxpost-wc-shipping-public.php';

		$this->loader = new Foxpost_Wc_Shipping_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Foxpost_Wc_Shipping_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Foxpost_Wc_Shipping_i18n();
		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );
	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Foxpost_Wc_Shipping_Admin( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
        //public function add_filter($hook, $component, $callback, $priority = 10, $accepted_args = 1)
        //public function add_action($hook, $component, $callback, $priority = 10, $accepted_args = 1)
  
        $this->loader->add_filter('woocommerce_settings_tabs_array',            $plugin_admin,      'woo_add_settings_tab',      50  );        
        $this->loader->add_action('woocommerce_settings_foxpost_wc_shipping',   $plugin_admin,      'woo_settings_tabs_settings'     );
        $this->loader->add_action('woocommerce_settings_save_foxpost_wc_shipping', $plugin_admin,   'woo_settings_save'              );


        //do_action( 'woocommerce_admin_field_' . $value['type'], $value ); 
        $this->loader->add_action('woocommerce_admin_field_codfee',     $plugin_admin,   'render_custom_setting_html'             );
        $this->loader->add_action('woocommerce_admin_field_testbutton', $plugin_admin,   'render_custom_setting_html'             );
        $this->loader->add_action('woocommerce_admin_field_button',     $plugin_admin,   'render_custom_setting_html'             );
        $this->loader->add_action('woocommerce_admin_field_status-selector',    $plugin_admin,   'render_custom_setting_html'     );
                                        
        //a szállítási modok
        $this->loader->add_filter('woocommerce_shipping_methods', $plugin_admin, 'define_shipping_methods');
    
 		//$this->loader->add_action( 'woocommerce_cart_totals_before_order_total',   $plugin_admin, 'add_codfee' );     
        
        //$this->loader->add_action('admin_init', $plugin_admin, 'woo_parcel_admin_init');
                                                                    
        $this->loader->add_action('woocommerce_admin_order_data_after_shipping_address', $plugin_admin, 'woocommerce_admin_order_data_after_shipping_address', 1, 1);        
        
        //Order page
		$this->loader->add_action( 'wp_ajax_foxpost_wc_shipping_get_parcel_label',       $plugin_admin, 'get_parcel_label');
		$this->loader->add_action( 'wp_ajax_foxpost_wc_shipping_get_parcel_status',       $plugin_admin, 'get_parcel_status');
        //Settings page
		$this->loader->add_action( 'wp_ajax_foxpost_wc_shipping_get_parcel_addresses',       $plugin_admin, 'get_parcel_addresses');

        //Orders page               
		$this->loader->add_action( 'wp_ajax_foxpost_wc_shipping_sync_parcel_status',       $plugin_admin, 'sync_parcel_status');
        
        //EMail
        //woocommerce_email_after_order_table ($order, $sent_to_admin, $plain_text, $email): The content is placed directly below the order table using this hook.
		$this->loader->add_action( 'woocommerce_email_after_order_table',       $plugin_admin, 'email_after_order_table', 4, 4);

        //Csoportos műveletek
		$this->loader->add_filter( 'bulk_actions-edit-shop_order',      $plugin_admin, 'foxpost_wc_shipping_bulk_actions', 20, 1 );
        // WooCommerce 9 bulk actions
		$this->loader->add_filter( 'bulk_actions-woocommerce_page_wc-orders',      $plugin_admin, 'foxpost_wc_shipping_bulk_actions', 20, 1 );
        //Make  action widt selected orders
		$this->loader->add_filter( 'handle_bulk_actions-edit-shop_order',      $plugin_admin, 'foxpost_wc_shipping_handle_bulk_action_edit_shop_order', 10, 3 );
        // WooCommerce 9 bulk actions handlers
        $this->loader->add_filter( 'handle_bulk_actions-woocommerce_page_wc-orders',      $plugin_admin, 'foxpost_wc_shipping_handle_bulk_action_edit_shop_order', 10, 3 );

		$this->loader->add_action( 'admin_notices', $plugin_admin, 'foxpost_wc_shipping_admin_notice' );
        
        //Rendelések oldalon az oszlopok
		$this->loader->add_filter( 'manage_edit-shop_order_columns',          $plugin_admin,  'customizing_orders_columns' );
		// WooCommerce 9
        $this->loader->add_filter( 'manage_woocommerce_page_wc-orders_columns',          $plugin_admin,  'customizing_orders_columns' );
		$this->loader->add_action( 'manage_shop_order_posts_custom_column',   $plugin_admin,  'set_custom_shipping_address_content_replacement' );
		// WooCommerce 9
        $this->loader->add_action( 'manage_woocommerce_page_wc-orders_custom_column',   $plugin_admin,  'set_custom_shipping_address_content_replacement', 10, 2 );
      
        //Settings link under plugin name on plugin page                                                                                                   
		$this->loader->add_filter('plugin_action_links',  $plugin_admin, 'add_plugin_link', 10, 2 );
        

        //woocommerce_admin_order_item_values                                                                                              
		//$this->loader->add_filter('woocommerce_admin_order_item_values',  $plugin_admin, 'admin_order_item_values', 10, 3 );        

		//Create metabox for labels on order edit page, nem kell még...
		//$this->loader->add_action( 'add_meta_boxes',       $plugin_admin, 'add_metabox', 10, 2);
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Foxpost_Wc_Shipping_Public( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
        
                                             
		//Runs when a shipping method is selected
		$this->loader->add_action( 'woocommerce_checkout_update_order_review', $plugin_public, 'shipping_method_selected' );         //nem belépett vásárló
		$this->loader->add_action( 'woocommerce_shipping_method_chosen', $plugin_public, 'shipping_method_selected' );
        $this->loader->add_action( 'woocommerce_shipping_init', $plugin_public, 'shipping_method_selected' );

        
		//Add custom UI to cart page
		$this->loader->add_action( 'woocommerce_cart_totals_after_shipping', $plugin_public, 'wctas');
		$this->loader->add_action( 'woocommerce_before_shipping_calculator', $plugin_public, 'wbsc');
		$this->loader->add_action( 'woocommerce_after_shipping_calculator', $plugin_public, 'wasc');        

		//$this->loader->add_action( 'woocommerce_review_order_before_shipping', $plugin_public, 'wbsc');
		$this->loader->add_action( 'woocommerce_review_order_after_shipping', $plugin_public, 'wasc');    
                                            
                                            
       	//Saves the value to order meta
		$this->loader->add_action( 'woocommerce_checkout_update_order_meta', $plugin_public, 'save_checkout' );                                     
		$this->loader->add_action( 'woocommerce_store_api_checkout_update_order_meta', $plugin_public, 'save_checkout' );                                     
        
		//Function when a fox_wc is selected
		$this->loader->add_action( 'wp_ajax_foxpost_wc_shipping_select',          $plugin_public, 'select_apt_with_ajax' );
		$this->loader->add_action( 'wp_ajax_nopriv_foxpost_wc_shipping_select',   $plugin_public, 'select_apt_with_ajax' );             
		$this->loader->add_action( 'woocommerce_cart_calculate_fees',   $plugin_public, 'add_codfee' );     
 
        //ha változik a payment method
		$this->loader->add_action( 'woocommerce_review_order_before_payment',   $plugin_public, 'refresh_checkout_on_payment_methods_change' );     

        $this->loader->add_action( 'woocommerce_after_checkout_validation',   $plugin_public, 'after_checkout_validation', 10, 2 );     
        $this->loader->add_action('rest_api_init', $plugin_public, 'add_foxpost_selected_apt_endpoint');
		$this->loader->add_filter('woocommerce_shipping_packages', $plugin_public, 'hide_shipping_method_based_on_weight', 10, 1);
	}

    private function define_hpos_functions(){
        $hpos_class = new Foxpost_Wc_Shipping_HPOS();
        $this->loader->add_action( 'before_woocommerce_init', $hpos_class, 'add_hpos_compatibility');
    }

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {        
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Foxpost_Wc_Shipping_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

    /**
     * @since 1.0.0
     *
     * @param string
     */
    public static function getDir($part='basedir')
    {
        $path = wp_upload_dir( null, false );
        return $path[$part].DIRECTORY_SEPARATOR.'foxpost-wc-shipping'.DIRECTORY_SEPARATOR; 
    }     
  
    public static function getLastParcelSyncTime(){
        global  $wp_filesystem;
        $lastsyncfile = self::getDir('basedir').'logs/last_api.sync';
        if ( !file_exists($lastsyncfile) ){
            $wp_filesystem->put_contents($lastsyncfile, 0);
            return 0;
        }; 
        
        return $wp_filesystem->get_contents($lastsyncfile);     
    }  
                          
     
    public static function getNextParcelSyncTime(){
      $exist = WC()->queue()->search( array('hook'=>'foxpost_wc_shipping_parcel_update','status'=>ActionScheduler_Store::STATUS_PENDING), 'ids' );
      
      if ( empty($exist) ) {
        $first_run = new DateTime();
        $first_run->modify('+1 day');
        //$first_run->setTime(4,30);
        return $first_run->getTimestamp(); 
      }
          
      $next = WC()->queue()->get_next('foxpost_wc_shipping_parcel_update'); //array('status'=>ActionScheduler_Store::STATUS_PENDING)   , , 'foxpost_wc_shipping'
    
      return $next->getTimestamp();     
    }    
     
    /**
     * Set a prefixed session variable.
     *
     * @param string $key Key to set.
     * @param mixed $value Value to set.
     *
     * @since 1.0.1
     * @return bool
     */
    public static function setToSession($key, $value)
    {
        return set_site_transient(sprintf('%s_%s', self::NAME, $key), $value);
    }

    /**
     * @param string $key
     *
     * @since 1.0.1
     * @return bool
     */
    public static function removeFromSession($key)
    {
        return delete_site_transient(sprintf('%s_%s', self::NAME, $key));
    }

    /**
     * Get a prefixed session variable.
     *
     * @param string $key Key to get.
     * @param mixed $default used if the session variable isn't set.
     * @param boolean $delete delete or not.
     * 
     * @since 1.0.1
     * @return array|string value of session variable
     */
    public static function getFromSession($key, $default = null, $delete=false)
    {
        $value = get_site_transient(sprintf('%s_%s', self::NAME, $key));
        if ($delete && $value !== false) self::removeFromSession($key);
        
        return $value === false ? $default : $value;
    }

    /**
     * Load configs.
     *
     * 
     * @since 1.0.2
     * @return array
     */    
    public static function loadConfig()
    {
        $config = array();
        $configfile = plugin_dir_path( dirname( __FILE__ ) ) .'config.php';       
        if (file_exists($configfile)) $config = include ($configfile);       
        return $config;
    }
    
    /**
     * Gets APT data array.
     *
     * @param bool $force Reload data instead of transient.
     *
     * @return array|bool
     */
    public static function getAptData($force = false)
    {
        $aptList = get_transient('foxpost_wc_shipping_aptdata');
        if (false === $aptList || $force) {
            $aptResponse = Foxpost_Wc_Shipping_Method::getAptDataFromApi();
            if (is_wp_error($aptResponse)) {
                return false;
            }
            set_transient('foxpost_wc_shipping_aptdata', $aptResponse['body'], DAY_IN_SECONDS);
            $aptList = $aptResponse['body'];
        }
        $aptData = json_decode($aptList);
        
        $currentLocale = setlocale(LC_COLLATE, 0);
        setlocale(LC_COLLATE, 'hu_HU.utf8');
        usort($aptData, function ($a, $b) {
            return strcoll($a->city . $a->name, $b->city . $b->name);
        });
        setlocale(LC_COLLATE, $currentLocale);
        
        return $aptData;
    } 
    
    /**
     * Whether the given apt Id is valid or not.
     *
     * @param string $aptId
     * @param bool $force Reload data instead of transient.
     *
     * @return array|bool
     */
    public static function isValidAptId($aptId, $force = false)
    {
        $aptData = self::getAptData($force);
        foreach ($aptData as $apt) {
            if ((string) $aptId === (string) $apt->operator_id) {
                return $apt;
            }
        }

        return false;
    }
}
