(function( $ ) {
	'use strict';

	/**
	 * All of the code for your public-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.         
	 *    
	 */           
     
})( jQuery );

var foxpost_wc_shipping_public = {};
var MT = window.MT || {};

jQuery(document).ready(function($) {

    foxpost_wc_shipping_public = {
            init: function() {
                //console.log('foxpost_wc_shipping_public::init');
                
                jQuery(window).on("message", function(e) {
                    var apt = JSON.parse(e.originalEvent.data);

                    foxpost_wc_shipping_public.select_parcel_box(apt.operator_id);
        			//Hide the modal window
        			MT.modalWindow.hide();
                    return true;         
                });
                
           
            },                   
            show_modal: function() {
                    //console.log('foxpost_wc_shipping_public::show_modal');
            },   
            hide_modal: function() {
                    //console.log('foxpost_wc_shipping_public::hide_modal');
            },
            select_parcel_box: function(apt) {
                    //console.log('foxpost_wc_shipping_public::select_parcel_box:'+apt);
                    
                    
                    var page = 'checkout';
                    if( jQuery('body').hasClass('woocommerce-cart')) page = 'cart';   
                    var security = ''
                    var ajax_url = '';
        			//Set based on page
        			if(page == 'checkout') {
        				security = wc_checkout_params.update_order_review_nonce;
        				ajax_url = wc_checkout_params.ajax_url;
        			} else {
        				security = wc_cart_params.update_shipping_method_nonce;
        				ajax_url = wc_cart_params.ajax_url;
        			}

                    
        			//Create reuqest
        			var data = {
        				action: 'foxpost_wc_shipping_select',                   
        				security: security,
        				page: page,
                        apt: apt
        			};                     
                    
        			//Make ajax request
        			jQuery.post(ajax_url, data, function(response) {
        
        				//TODO handle error
        				if(response.success) {
        
        					// Refresh the review order section, so the selected point is visible automatically
        					jQuery('body').trigger('update_checkout');
        
        					//Update cart
        					if( jQuery('.cart_totals input.shipping_method:checked').length) {
        						jQuery('.cart_totals input.shipping_method:checked').trigger( 'change' );
        					} else {
        						jQuery('.cart_totals input.shipping_method').trigger( 'change' ); //This is when the only available option is the pont shipping one
        					}
        
        				} else {
        
        				}
        
        			});                    
                    
                    return true;
            }

    }
           
	//if( jQuery('.foxpost-wc-shipping-modal').length ) {      
		//foxpost_wc_shipping_public.init();
	//}
});