<?php
/**
0 (EMERG)
1 (ALERT)
2 (CRIT)
3 (ERR)
4 (WARNING)
5 (NOTICE)
6 (INFO)
7 (DEBUG)
*/
if (!defined('ABSPATH')) {
    die;
}

add_filter( 'woocommerce_logger_days_to_retain_logs', 'foxpost_wc_shipping_woocommerce_logger_days_to_retain_logs_filter' );
/**
 * Function for `woocommerce_logger_days_to_retain_logs` filter-hook.
 * 
 * @param  $day 
 *
 * @return 
 */
function foxpost_wc_shipping_woocommerce_logger_days_to_retain_logs_filter( $day ){
	return 8;
}


class Foxpost_Wc_Shipping_Logger {

    private $logger;
    
    public function __construct($logger=null) {       
		if ( ! class_exists( 'WC_Logger' ) ) {
            include_once( WP_PLUGIN_DIR . '/woocommerce/includes/interfaces/class-wc-logger-interface.php' );            
			include_once( WP_PLUGIN_DIR . '/woocommerce/includes/class-wc-logger.php' );
		}
        
        $this->logger = (!is_null($logger)) ? $logger : new WC_Logger();   
    }

    public function log($msg, $level=WC_Log_Levels::NOTICE){
        $context = array( 'source' => 'foxpost-wc-shipping' );
        if ( !is_string($msg) ) $msg = var_export($msg, true); 
        $this->logger->log($level, $msg, $context);
    }
        
    public function log_d($msg){
        if ( defined('WP_DEBUG') && constant("WP_DEBUG")==true )
            $this->log($msg, WC_Log_Levels::DEBUG);
	}
    public function log_i($msg){
        $this->log($msg, WC_Log_Levels::INFO);
	}
    public function log_n($msg){
        $this->log($msg, WC_Log_Levels::NOTICE);
	}
    public function log_w($msg){
        $this->log($msg, WC_Log_Levels::WARNING);
	} 
    public function log_e($msg){
        $this->log($msg, WC_Log_Levels::ERROR);
	}
    public function log_c($msg){
        $this->log($msg, WC_Log_Levels::CRITICAL);
	}
    public function log_a($msg){
        $this->log($msg, WC_Log_Levels::ALERT);
	}
    public function log_em($msg){
        $this->log($msg, WC_Log_Levels::EMERGENCY);
	} 

}














?>